/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.distributedlock.interceptor;

import com.cntaiping.ec.cloud.common.distributedlock.DistributedLock;
import com.cntaiping.ec.cloud.common.distributedlock.DistributedLockFactory;
import com.cntaiping.ec.cloud.common.distributedlock.LockResource;
import com.cntaiping.ec.cloud.common.distributedlock.interceptor.DistributedLockOperation;
import com.cntaiping.ec.cloud.common.distributedlock.interceptor.DistributedLockOperationExpressionEvaluator;
import com.cntaiping.ec.cloud.common.distributedlock.interceptor.DistributedLockOperationInvoker;
import com.cntaiping.ec.cloud.common.distributedlock.interceptor.DistributedLockOperationSource;
import com.cntaiping.ec.cloud.common.distributedlock.interceptor.KeyGenerator;
import com.cntaiping.ec.cloud.common.distributedlock.interceptor.SimpleKeyGenerator;
import com.cntaiping.ec.cloud.common.distributedlock.interceptor.SimpleLockResource;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.util.function.SupplierUtils;

public abstract class DistributedLockAspectSupport
implements BeanFactoryAware,
InitializingBean,
SmartInitializingSingleton {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<DistributedLockOperationCacheKey, DistributedLockOperationMetadata> metadataCache = new ConcurrentHashMap<DistributedLockOperationCacheKey, DistributedLockOperationMetadata>(1024);
    private final DistributedLockOperationExpressionEvaluator evaluator = new DistributedLockOperationExpressionEvaluator();
    @Nullable
    private DistributedLockOperationSource distributedLockOperationSource;
    private SingletonSupplier<KeyGenerator> keyGenerator = SingletonSupplier.of(SimpleKeyGenerator::new);
    @Nullable
    private Supplier<DistributedLockFactory> distributedLockFactory;
    @Nullable
    private BeanFactory beanFactory;
    private boolean initialized = false;

    public void configure(@Nullable Supplier<KeyGenerator> keyGenerator, @Nullable Supplier<DistributedLockFactory> distributedLockFactory) {
        this.keyGenerator = new SingletonSupplier(keyGenerator, SimpleKeyGenerator::new);
        this.distributedLockFactory = distributedLockFactory;
    }

    public void setDistributedLockOperationSource(@Nullable DistributedLockOperationSource distributedLockOperationSource) {
        this.distributedLockOperationSource = distributedLockOperationSource;
    }

    @Nullable
    public DistributedLockOperationSource getDistributedLockOperationSource() {
        return this.distributedLockOperationSource;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = SingletonSupplier.of((Object)keyGenerator);
    }

    public KeyGenerator getKeyGenerator() {
        return (KeyGenerator)this.keyGenerator.obtain();
    }

    public void setDistributedLockFactory(@Nullable DistributedLockFactory distributedLockFactory) {
        this.distributedLockFactory = SingletonSupplier.ofNullable((Object)distributedLockFactory);
    }

    @Nullable
    public DistributedLockFactory getDistributedLockFactory() {
        return (DistributedLockFactory)SupplierUtils.resolve(this.distributedLockFactory);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.getDistributedLockOperationSource() != null ? 1 : 0) != 0, (String)"The 'distributedLockOperationSource' property is required: If there are no distributedLockable methods, then don't use a distributedLock aspect.");
    }

    public void afterSingletonsInstantiated() {
        if (this.getDistributedLockFactory() == null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"distributedLockFactory or BeanFactory must be set on distributedLock aspect");
            try {
                this.setDistributedLockFactory((DistributedLockFactory)this.beanFactory.getBean(DistributedLockFactory.class));
            }
            catch (NoUniqueBeanDefinitionException ex) {
                throw new IllegalStateException("No DistributedLockFactory specified, and no unique bean of type DistributedLockFactory found. Mark one as primary or declare a specific DistributedLockFactory to use.");
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new IllegalStateException("No DistributedLockFactory specified, and no bean of type DistributedLockFactory found. Register a DistributedLockFactory bean or remove the @EnableDistributedLocking annotation from your configuration.");
            }
        }
        this.initialized = true;
    }

    protected String methodIdentification(Method method, Class<?> targetClass) {
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        return ClassUtils.getQualifiedMethodName((Method)specificMethod);
    }

    protected DistributedLockOperationContext getOperationContext(DistributedLockOperation operation, Method method, Object[] args, Object target, Class<?> targetClass) {
        DistributedLockOperationMetadata metadata = this.getDistributedLockOperationMetadata(operation, method, targetClass);
        return new DistributedLockOperationContext(metadata, args, target);
    }

    protected DistributedLockOperationMetadata getDistributedLockOperationMetadata(DistributedLockOperation operation, Method method, Class<?> targetClass) {
        DistributedLockOperationCacheKey cacheKey = new DistributedLockOperationCacheKey(operation, method, targetClass);
        DistributedLockOperationMetadata metadata = this.metadataCache.get(cacheKey);
        if (metadata == null) {
            DistributedLockFactory operationDistributedLockFactory;
            KeyGenerator operationKeyGenerator = StringUtils.hasText((String)operation.getKeyGenerator()) ? this.getBean(operation.getKeyGenerator(), KeyGenerator.class) : this.getKeyGenerator();
            if (StringUtils.hasText((String)operation.getDistributedLockFactory())) {
                operationDistributedLockFactory = this.getBean(operation.getDistributedLockFactory(), DistributedLockFactory.class);
            } else {
                operationDistributedLockFactory = this.getDistributedLockFactory();
                Assert.state((operationDistributedLockFactory != null ? 1 : 0) != 0, (String)"No DistributedLockFactory set");
            }
            metadata = new DistributedLockOperationMetadata(operation, method, targetClass, operationKeyGenerator, operationDistributedLockFactory);
            this.metadataCache.put(cacheKey, metadata);
        }
        return metadata;
    }

    protected <T> T getBean(String beanName, Class<T> expectedType) {
        if (this.beanFactory == null) {
            throw new IllegalStateException("BeanFactory must be set on distributedLock aspect for " + expectedType.getSimpleName() + " retrieval");
        }
        return (T)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)this.beanFactory, expectedType, (String)beanName);
    }

    protected void clearMetadataCache() {
        this.metadataCache.clear();
        this.evaluator.clear();
    }

    @Nullable
    protected Object execute(DistributedLockOperationInvoker invoker, Object target, Method method, Object[] args) {
        if (this.initialized) {
            DistributedLockOperation operation;
            Class<?> targetClass = this.getTargetClass(target);
            DistributedLockOperationSource distributedLockOperationSource = this.getDistributedLockOperationSource();
            if (distributedLockOperationSource != null && (operation = distributedLockOperationSource.getDistributedLockOperation(method, targetClass)) != null) {
                return this.execute(invoker, method, this.getOperationContext(operation, method, args, target, targetClass));
            }
        }
        return invoker.invoke();
    }

    protected Object invokeOperation(DistributedLockOperationInvoker invoker) {
        return invoker.invoke();
    }

    private Class<?> getTargetClass(Object target) {
        return AopProxyUtils.ultimateTargetClass((Object)target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object execute(DistributedLockOperationInvoker invoker, Method method, DistributedLockOperationContext context) {
        DistributedLock distributedLock = this.getDistributedLock(context);
        boolean locked = distributedLock.tryLock(context.getOperation().getTime(), context.getOperation().getUnit());
        try {
            if (locked) {
                Object object = this.unwrapReturnValue(this.invokeOperation(invoker));
                return object;
            }
            this.logger.warn((Object)("try lock " + distributedLock.getName() + " failed"));
        }
        catch (Exception ex) {
            ReflectionUtils.rethrowRuntimeException((Throwable)ex.getCause());
        }
        finally {
            distributedLock.unLock();
        }
        return null;
    }

    private DistributedLock getDistributedLock(DistributedLockOperationContext context) {
        LockResource lockResource = this.generateKey(context);
        DistributedLockFactory distributedLockFactory = context.getDistributedLockFactory();
        return distributedLockFactory.create(lockResource);
    }

    private LockResource generateKey(DistributedLockOperationContext context) {
        LockResource key = context.generateKey();
        if (key == null) {
            throw new IllegalArgumentException("Null key returned for distributedLock operation (maybe you are using named params on classes without debug info?) " + context.metadata.operation);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Computed lock key '" + key + "' for operation " + context.metadata.operation));
        }
        return key;
    }

    @Nullable
    private Object unwrapReturnValue(Object returnValue) {
        return ObjectUtils.unwrapOptional((Object)returnValue);
    }

    private static final class DistributedLockOperationCacheKey
    implements Comparable<DistributedLockOperationCacheKey> {
        private final DistributedLockOperation distributedLockOperation;
        private final AnnotatedElementKey methodCacheKey;

        private DistributedLockOperationCacheKey(DistributedLockOperation distributedLockOperation, Method method, Class<?> targetClass) {
            this.distributedLockOperation = distributedLockOperation;
            this.methodCacheKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DistributedLockOperationCacheKey)) {
                return false;
            }
            DistributedLockOperationCacheKey otherKey = (DistributedLockOperationCacheKey)other;
            return this.distributedLockOperation.equals(otherKey.distributedLockOperation) && this.methodCacheKey.equals((Object)otherKey.methodCacheKey);
        }

        public int hashCode() {
            return this.distributedLockOperation.hashCode() * 31 + this.methodCacheKey.hashCode();
        }

        public String toString() {
            return this.distributedLockOperation + " on " + this.methodCacheKey;
        }

        @Override
        public int compareTo(DistributedLockOperationCacheKey other) {
            int result = this.distributedLockOperation.getName().compareTo(other.distributedLockOperation.getName());
            if (result == 0) {
                result = this.methodCacheKey.compareTo(other.methodCacheKey);
            }
            return result;
        }
    }

    protected class DistributedLockOperationContext {
        private final DistributedLockOperationMetadata metadata;
        private final Object[] args;
        private final Object target;
        private final DistributedLockFactory distributedLockFactory;

        public DistributedLockOperationContext(DistributedLockOperationMetadata metadata, Object[] args, Object target) {
            this.metadata = metadata;
            this.args = this.extractArgs(metadata.method, args);
            this.target = target;
            this.distributedLockFactory = DistributedLockAspectSupport.this.getDistributedLockFactory();
        }

        public DistributedLockOperation getOperation() {
            return this.metadata.operation;
        }

        public Object getTarget() {
            return this.target;
        }

        public Method getMethod() {
            return this.metadata.method;
        }

        public Object[] getArgs() {
            return this.args;
        }

        private Object[] extractArgs(Method method, Object[] args) {
            if (!method.isVarArgs()) {
                return args;
            }
            Object[] varArgs = ObjectUtils.toObjectArray((Object)args[args.length - 1]);
            Object[] combinedArgs = new Object[args.length - 1 + varArgs.length];
            System.arraycopy(args, 0, combinedArgs, 0, args.length - 1);
            System.arraycopy(varArgs, 0, combinedArgs, args.length - 1, varArgs.length);
            return combinedArgs;
        }

        @Nullable
        protected LockResource generateKey() {
            Object key = null;
            if (StringUtils.hasText((String)this.metadata.operation.getKey())) {
                EvaluationContext evaluationContext = this.createEvaluationContext();
                key = DistributedLockAspectSupport.this.evaluator.key(this.metadata.operation.getKey(), this.metadata.methodKey, evaluationContext);
            } else {
                key = this.metadata.keyGenerator.generate(this.target, this.metadata.method, this.args);
            }
            return new SimpleLockResource(this.metadata.operation.getLockResource()).of(key.toString());
        }

        private EvaluationContext createEvaluationContext() {
            return DistributedLockAspectSupport.this.evaluator.createEvaluationContext(this.distributedLockFactory, this.metadata.method, this.args, this.target, this.metadata.targetClass, this.metadata.targetMethod, DistributedLockAspectSupport.this.beanFactory);
        }

        protected DistributedLockFactory getDistributedLockFactory() {
            return this.distributedLockFactory;
        }
    }

    protected static class DistributedLockOperationMetadata {
        private final DistributedLockOperation operation;
        private final Method method;
        private final Class<?> targetClass;
        private final Method targetMethod;
        private final AnnotatedElementKey methodKey;
        private final KeyGenerator keyGenerator;
        private final DistributedLockFactory distributedLockFactory;

        public DistributedLockOperationMetadata(DistributedLockOperation operation, Method method, Class<?> targetClass, KeyGenerator keyGenerator, DistributedLockFactory distributedLockFactory) {
            this.operation = operation;
            this.method = BridgeMethodResolver.findBridgedMethod((Method)method);
            this.targetClass = targetClass;
            this.targetMethod = !Proxy.isProxyClass(targetClass) ? AopUtils.getMostSpecificMethod((Method)method, targetClass) : this.method;
            this.methodKey = new AnnotatedElementKey((AnnotatedElement)this.targetMethod, targetClass);
            this.keyGenerator = keyGenerator;
            this.distributedLockFactory = distributedLockFactory;
        }
    }
}

