/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.distributedlock.interceptor;

import java.util.concurrent.TimeUnit;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DistributedLockOperation {
    private final String name;
    private final String lockResource;
    private final String key;
    private final String keyGenerator;
    private final String distributedLockFactory;
    private final long time;
    private final TimeUnit unit;
    private final String toString;

    public static Builder builder() {
        return new Builder();
    }

    private DistributedLockOperation(Builder builder) {
        this.name = builder.name;
        this.lockResource = builder.lockResource;
        this.key = builder.key;
        this.keyGenerator = builder.keyGenerator;
        this.distributedLockFactory = builder.distributedLockFactory;
        this.time = builder.time;
        this.unit = builder.unit;
        this.toString = builder.getOperationDescription().toString();
    }

    public String getName() {
        return this.name;
    }

    public String getLockResource() {
        return this.lockResource;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyGenerator() {
        return this.keyGenerator;
    }

    public String getDistributedLockFactory() {
        return this.distributedLockFactory;
    }

    public long getTime() {
        return this.time;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof DistributedLockOperation && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        return this.toString;
    }

    public static class Builder {
        private String name = "";
        private String lockResource = "";
        private String key = "";
        private String keyGenerator = "";
        private String distributedLockFactory = "";
        private long time = -1L;
        private TimeUnit unit = TimeUnit.MILLISECONDS;

        public String getName() {
            return this.name;
        }

        public String getLockResource() {
            return this.lockResource;
        }

        public String getKey() {
            return this.key;
        }

        public String getKeyGenerator() {
            return this.keyGenerator;
        }

        public String getDistributedLockFactory() {
            return this.distributedLockFactory;
        }

        public long getTime() {
            return this.time;
        }

        public TimeUnit getUnit() {
            return this.unit;
        }

        public void setName(String name) {
            Assert.hasText((String)name, (String)"Name must not be empty");
            this.name = name;
        }

        public void setLockResource(String lockResource) {
            Assert.hasText((String)this.name, (String)"Name must not be empty");
            this.lockResource = lockResource;
        }

        public void setKey(String key) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            this.key = key;
        }

        public void setKeyGenerator(String keyGenerator) {
            Assert.notNull((Object)keyGenerator, (String)"KeyGenerator name must not be null");
            this.keyGenerator = keyGenerator;
        }

        public void setDistributedLockFactory(String distributedLockFactory) {
            Assert.notNull((Object)distributedLockFactory, (String)"DistributedLockFactory name must not be null");
            this.distributedLockFactory = distributedLockFactory;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setUnit(TimeUnit unit) {
            Assert.notNull((Object)((Object)unit), (String)"TimeUnit must not be null");
            this.unit = unit;
        }

        protected StringBuilder getOperationDescription() {
            StringBuilder result = new StringBuilder(this.getClass().getSimpleName());
            result.append("[").append(this.name);
            result.append("] lockResource=").append(this.lockResource);
            result.append(" | key='").append(this.key);
            result.append("' | keyGenerator='").append(this.keyGenerator);
            result.append("' | distributedLockFactory='").append(this.distributedLockFactory);
            result.append("' | time='").append(this.time);
            result.append("' | unit='").append((Object)this.unit).append("'");
            return result;
        }

        public DistributedLockOperation build() {
            return new DistributedLockOperation(this);
        }
    }
}

