/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.distributedlock.interceptor;

import com.cntaiping.ec.cloud.common.distributedlock.annotations.DistributedLockAnnotationParser;
import com.cntaiping.ec.cloud.common.distributedlock.annotations.DistributedLockConfig;
import com.cntaiping.ec.cloud.common.distributedlock.annotations.DistributedLockable;
import com.cntaiping.ec.cloud.common.distributedlock.interceptor.DistributedLockOperation;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class SpringDistributedLockAnnotationParser
implements DistributedLockAnnotationParser,
Serializable {
    @Override
    public boolean isCandidateClass(Class<?> targetClass) {
        return AnnotationUtils.isCandidateClass(targetClass, DistributedLockable.class);
    }

    @Override
    @Nullable
    public DistributedLockOperation parseDistributedLockAnnotation(Method method) {
        DefaultDistributedLockConfig defaultDistributedLockConfig = new DefaultDistributedLockConfig(method.getDeclaringClass());
        return this.parseDistributedLockAnnotation(defaultDistributedLockConfig, method);
    }

    @Nullable
    private DistributedLockOperation parseDistributedLockAnnotation(DefaultDistributedLockConfig distributedLockConfig, AnnotatedElement ae) {
        DistributedLockable dl = (DistributedLockable)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)ae, DistributedLockable.class);
        if (dl == null) {
            dl = (DistributedLockable)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)ae, DistributedLockable.class);
        }
        if (dl == null) {
            return null;
        }
        return this.parseDistributedLockAnnotation(ae, distributedLockConfig, dl);
    }

    private DistributedLockOperation parseDistributedLockAnnotation(AnnotatedElement ae, DefaultDistributedLockConfig defaultConfig, DistributedLockable dl) {
        DistributedLockOperation.Builder builder = new DistributedLockOperation.Builder();
        builder.setName(ae.toString());
        builder.setLockResource(dl.lockResource());
        builder.setKey(dl.key());
        builder.setKeyGenerator(dl.keyGenerator());
        builder.setDistributedLockFactory(dl.distributedLockFactory());
        builder.setTime(dl.time());
        builder.setUnit(dl.unit());
        defaultConfig.applyDefault(builder);
        DistributedLockOperation op = builder.build();
        this.validateDistributedLockOperation(ae, op);
        return op;
    }

    private void validateDistributedLockOperation(AnnotatedElement ae, DistributedLockOperation operation) {
        if (StringUtils.hasText((String)operation.getKey()) && StringUtils.hasText((String)operation.getKeyGenerator())) {
            throw new IllegalStateException("Invalid distributedLock annotation configuration on '" + ae.toString() + "'. Both 'key' and 'keyGenerator' attributes have been set. These attributes are mutually exclusive: either set the SpEL expression used tocompute the key at runtime or set the name of the KeyGenerator bean to use.");
        }
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SpringDistributedLockAnnotationParser;
    }

    public int hashCode() {
        return SpringDistributedLockAnnotationParser.class.hashCode();
    }

    private static class DefaultDistributedLockConfig {
        private final Class<?> target;
        @Nullable
        private String lockResource;
        @Nullable
        private String keyGenerator;
        @Nullable
        private String distributedLockFactory;
        private boolean initialized = false;

        public DefaultDistributedLockConfig(Class<?> target) {
            this.target = target;
        }

        public void applyDefault(DistributedLockOperation.Builder builder) {
            if (!this.initialized) {
                DistributedLockConfig annotation = (DistributedLockConfig)AnnotatedElementUtils.findMergedAnnotation(this.target, DistributedLockConfig.class);
                if (annotation != null) {
                    this.lockResource = annotation.lockResource();
                    this.keyGenerator = annotation.keyGenerator();
                    this.distributedLockFactory = annotation.distributedLockFactory();
                }
                this.initialized = true;
            }
            if (!StringUtils.hasText((String)builder.getLockResource()) && this.lockResource != null) {
                builder.setLockResource(this.lockResource);
            }
            if (!StringUtils.hasText((String)builder.getKey()) && !StringUtils.hasText((String)builder.getKeyGenerator()) && StringUtils.hasText((String)this.keyGenerator)) {
                builder.setKeyGenerator(this.keyGenerator);
            }
            if (!StringUtils.hasText((String)builder.getDistributedLockFactory()) && StringUtils.hasText((String)this.distributedLockFactory)) {
                builder.setDistributedLockFactory(this.distributedLockFactory);
            }
        }
    }
}

