/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.exception;

import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;

public class BaseRuntimeException
extends RuntimeException
implements MessageSourceResolvable {
    private static final long serialVersionUID = -3617744653279475003L;
    private final DefaultMessageSourceResolvable messageSourceResolvable;
    private boolean alreadyLogged;

    public boolean isAlreadyLogged() {
        return this.alreadyLogged;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        this.alreadyLogged = true;
        return super.getStackTrace();
    }

    protected BaseRuntimeException(String code) {
        super(BaseRuntimeException.getErrorMsg(code, null));
        this.messageSourceResolvable = new DefaultMessageSourceResolvable(code);
    }

    protected BaseRuntimeException(String code, Object[] args) {
        super(BaseRuntimeException.getErrorMsg(code, null));
        this.messageSourceResolvable = new DefaultMessageSourceResolvable(new String[]{code}, args);
    }

    protected BaseRuntimeException(String code, Throwable th) {
        super(BaseRuntimeException.getErrorMsg(code, null), th);
        this.messageSourceResolvable = th instanceof MessageSourceResolvable ? new DefaultMessageSourceResolvable((MessageSourceResolvable)th) : new DefaultMessageSourceResolvable(new String[]{code}, null, th.getMessage());
    }

    protected BaseRuntimeException(String code, Object[] args, Throwable th) {
        super(BaseRuntimeException.getErrorMsg(code, null), th);
        this.messageSourceResolvable = th instanceof MessageSourceResolvable ? new DefaultMessageSourceResolvable((MessageSourceResolvable)th) : new DefaultMessageSourceResolvable(new String[]{code}, args, th.getMessage());
    }

    protected BaseRuntimeException(String code, String defaultMsg) {
        super(BaseRuntimeException.getErrorMsg(code, defaultMsg));
        this.messageSourceResolvable = new DefaultMessageSourceResolvable(new String[]{code}, null, defaultMsg);
    }

    protected BaseRuntimeException(String code, Object[] args, String defaultMsg) {
        super(BaseRuntimeException.getErrorMsg(code, defaultMsg));
        this.messageSourceResolvable = new DefaultMessageSourceResolvable(new String[]{code}, args, defaultMsg);
    }

    protected BaseRuntimeException(String code, String defaultMsg, Throwable th) {
        super(BaseRuntimeException.getErrorMsg(code, defaultMsg), th);
        this.messageSourceResolvable = th instanceof MessageSourceResolvable ? new DefaultMessageSourceResolvable((MessageSourceResolvable)th) : new DefaultMessageSourceResolvable(new String[]{code}, new Object[]{th.getClass().getName()}, defaultMsg);
    }

    protected BaseRuntimeException(String code, Object[] args, String defaultMsg, Throwable th) {
        super(BaseRuntimeException.getErrorMsg(code, defaultMsg), th);
        this.messageSourceResolvable = th instanceof MessageSourceResolvable ? new DefaultMessageSourceResolvable((MessageSourceResolvable)th) : new DefaultMessageSourceResolvable(new String[]{code}, args, defaultMsg);
    }

    private static String getErrorMsg(String code, String defaultMsg) {
        if (code == null) {
            return defaultMsg;
        }
        if (defaultMsg == null) {
            return "[" + code + "]";
        }
        return "[" + code + "]" + defaultMsg;
    }

    public String getCode() {
        return this.messageSourceResolvable.getCode();
    }

    public String[] getCodes() {
        return this.messageSourceResolvable.getCodes();
    }

    public Object[] getArguments() {
        return this.messageSourceResolvable.getArguments();
    }

    public String getDefaultMessage() {
        return this.messageSourceResolvable.getDefaultMessage();
    }
}

