/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.exception;

import com.cntaiping.ec.cloud.common.SystemProperties;
import com.cntaiping.ec.cloud.common.exception.BaseRuntimeException;
import com.cntaiping.ec.cloud.common.exception.ErrorDetail;
import com.cntaiping.ec.cloud.common.exception.ExceptionHandler;
import com.cntaiping.ec.cloud.common.exception.ExceptionProperties;
import com.cntaiping.ec.cloud.common.exception.HandlerExceptionResolverCustomizer;
import com.cntaiping.ec.cloud.common.exception.provider.ErrorStatistics;
import com.cntaiping.ec.cloud.common.exception.provider.ErrorStatisticsProvider;
import com.cntaiping.ec.cloud.common.utils.trace.TraceUtils;
import io.prometheus.client.Counter;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;

public class BasicHandlerExceptionResolver
extends AbstractHandlerExceptionResolver
implements InitializingBean,
EnvironmentAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicHandlerExceptionResolver.class);
    public static final Counter EXCEPTION_COUNTER = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("taiping_cloud_exception_counter")).labelNames(new String[]{"service", "instance", "uri", "code"})).help("Taiping-Cloud Exception Counter")).register();
    private String service;
    private ExceptionHandler exceptionHandler;
    private SystemProperties systemProperties;
    private ExceptionProperties exceptionProperties;
    private ObjectProvider<HandlerExceptionResolverCustomizer> handlerExceptionResolverCustomizers;
    private ErrorStatisticsProvider<ErrorStatistics> errorStatisticsProvider;

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ErrorDetail errorDetail = this.exceptionHandler.handleException(ex, request.getLocale());
        this.errorStatistics(errorDetail, request);
        ModelAndView modelAndView = this.getModelAndView(errorDetail);
        this.handlerExceptionResolverCustomizers.orderedStream().forEach(customizer -> customizer.customize(request, response, handler, ex, modelAndView));
        return modelAndView;
    }

    protected void errorStatistics(ErrorDetail errorDetail, HttpServletRequest request) {
        this.errorStatisticsProvider.compute(ErrorStatistics.builder().traceNo(TraceUtils.get()).systemCode(this.systemProperties.getSystemCode()).service(this.service).instance(this.systemProperties.getHostName()).endpoint(request.getRequestURI()).code(errorDetail.getCode()).message(errorDetail.getMessage()).cause(errorDetail.getCause()).createTime(new Date()).build());
        if (this.exceptionProperties.isEnablePrometheus()) {
            ((Counter.Child)EXCEPTION_COUNTER.labels(new String[]{this.service, this.systemProperties.getHostName(), request.getRequestURI(), errorDetail.getCode()})).inc();
        }
    }

    protected ModelAndView getModelAndView(ErrorDetail errorDetail) {
        ExceptionProperties.View view = this.exceptionProperties.getView();
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setStatus(HttpStatus.OK);
        modelAndView.setViewName(view.getViewName());
        modelAndView.addObject(view.getErrorCodeKey(), (Object)errorDetail.getCode());
        modelAndView.addObject(view.getErrorMsgKey(), (Object)errorDetail.getMessage());
        if (view.isOutputSuccess()) {
            modelAndView.addObject(view.getSuccessKey(), (Object)false);
        }
        if (view.isOutputCause()) {
            modelAndView.addObject(view.getCauseKey(), (Object)errorDetail.getCause());
        }
        if (view.isOutputHostName()) {
            modelAndView.addObject(view.getHostNameKey(), (Object)errorDetail.getHostName());
        }
        if (view.isOutputData()) {
            modelAndView.addObject(view.getDataKey(), null);
        }
        return modelAndView;
    }

    protected void logException(Exception ex, HttpServletRequest request) {
        if (ex instanceof BaseRuntimeException && ((BaseRuntimeException)ex).isAlreadyLogged()) {
            return;
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("An error occurred when requesting [{}]", (Object)request.getRequestURI(), (Object)ex);
        }
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public SystemProperties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(SystemProperties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public ExceptionProperties getExceptionProperties() {
        return this.exceptionProperties;
    }

    public void setExceptionProperties(ExceptionProperties exceptionProperties) {
        this.exceptionProperties = exceptionProperties;
    }

    public ObjectProvider<HandlerExceptionResolverCustomizer> getHandlerExceptionResolverCustomizers() {
        return this.handlerExceptionResolverCustomizers;
    }

    public void setHandlerExceptionResolverCustomizers(ObjectProvider<HandlerExceptionResolverCustomizer> handlerExceptionResolverCustomizers) {
        this.handlerExceptionResolverCustomizers = handlerExceptionResolverCustomizers;
    }

    public ErrorStatisticsProvider<ErrorStatistics> getErrorStatisticsProvider() {
        return this.errorStatisticsProvider;
    }

    public void setErrorStatisticsProvider(ErrorStatisticsProvider<ErrorStatistics> errorStatisticsProvider) {
        this.errorStatisticsProvider = errorStatisticsProvider;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.exceptionHandler, (String)"ExceptionHandler must not be null.");
        Assert.notNull((Object)this.exceptionProperties, (String)"ExceptionProperties must not be null.");
    }

    public void setEnvironment(Environment environment) {
        this.service = environment.getProperty("spring.application.name", "default");
    }
}

