/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.exception;

import com.cntaiping.ec.cloud.common.MessagesProvider;
import com.cntaiping.ec.cloud.common.SystemProperties;
import com.cntaiping.ec.cloud.common.exception.ErrorDetail;
import com.cntaiping.ec.cloud.common.exception.ExceptionHandler;
import com.cntaiping.ec.cloud.common.exception.ExceptionProperties;
import com.cntaiping.ec.cloud.common.exception.ExceptionUtil;
import com.cntaiping.ec.cloud.common.exception.TPSCBPError;
import com.cntaiping.ec.cloud.common.log.LogInfo;
import com.cntaiping.ec.cloud.common.log.LogUtils;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.util.Assert;

public class DefaultExceptionHandler
implements ExceptionHandler,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExceptionHandler.class);
    private Pattern regex;
    private MessagesProvider messagesProvider;
    private SystemProperties systemProperties;
    private ExceptionProperties exceptionProperties;

    @Override
    public ErrorDetail handleException(Throwable throwable, Locale locale) {
        String errorCode = null;
        String errorMsg = null;
        String cause = null;
        try {
            throwable = ExceptionUtil.unwrapThrowable(throwable);
            cause = throwable.getMessage();
            String defaultMessage = null;
            Object[] arguments = null;
            String className = throwable.getClass().getName();
            errorCode = (String)this.messagesProvider.resolveError(className, null, null, locale);
            if (errorCode == null || errorCode.equals(className)) {
                errorCode = null;
                if (throwable instanceof MessageSourceResolvable) {
                    MessageSourceResolvable messagesourceresolvable = (MessageSourceResolvable)throwable;
                    String[] codes = messagesourceresolvable.getCodes();
                    if (codes != null && codes.length > 0) {
                        errorCode = codes[0];
                    }
                    if (messagesourceresolvable.getDefaultMessage() != null) {
                        defaultMessage = messagesourceresolvable.getDefaultMessage();
                    }
                    arguments = messagesourceresolvable.getArguments();
                }
            }
            if (errorCode == null) {
                errorCode = TPSCBPError.UNKNOWN.getInfo().getCode();
                errorMsg = (String)this.messagesProvider.resolveError(throwable, locale);
            } else {
                errorCode = this.mappingCode(errorCode);
                errorMsg = (String)this.messagesProvider.resolveError(errorCode, arguments, defaultMessage, locale);
            }
        }
        catch (Exception e) {
            LOGGER.warn("An error occurred while parsing the exception information", (Throwable)e);
        }
        ErrorDetail errorDetail = this.getErrorDetail(errorCode, errorMsg, cause);
        this.setLogInfo(errorDetail);
        return errorDetail;
    }

    private void setLogInfo(ErrorDetail errorDetail) {
        LogInfo logInfo = LogUtils.current(false);
        if (logInfo != null) {
            logInfo.setSuccess(false);
            logInfo.setCode(errorDetail.getCode());
            logInfo.setMessage(errorDetail.getMessage());
            logInfo.setCause(errorDetail.getCause());
        }
    }

    private String mappingCode(String errorCode) {
        if (this.exceptionProperties.getMessageCodeMapping() != null) {
            String mappingCode = this.exceptionProperties.getMessageCodeMapping().get(errorCode);
            if (mappingCode != null) {
                errorCode = mappingCode;
            } else if (this.exceptionProperties.isUseDefaultMappingCode() && this.exceptionProperties.getDefaultMappingCode() != null) {
                errorCode = this.exceptionProperties.getDefaultMappingCode();
            }
        }
        return errorCode;
    }

    private ErrorDetail getErrorDetail(String errorCode, String errorMsg, String cause) {
        if (this.systemProperties != null && this.exceptionProperties.isRebuildMessageCode()) {
            errorCode = this.compile(errorCode, this.systemProperties.getSystemCode());
        }
        String hostName = null;
        if (this.systemProperties != null && this.exceptionProperties.isOutputHostName()) {
            hostName = this.systemProperties.getHostName();
        }
        return ErrorDetail.builder().code(errorCode).message(errorMsg).cause(cause == null ? "unknown" : cause).hostName(hostName).build();
    }

    protected String compile(String errorCode, String systemCode) {
        try {
            if (errorCode != null) {
                Matcher matcher = this.regex.matcher(errorCode);
                if (matcher.matches()) {
                    return errorCode.replace(matcher.group(1), systemCode);
                }
                return errorCode;
            }
        }
        catch (Exception e) {
            LOGGER.warn("An error occurred while parsing the error code", (Throwable)e);
        }
        return this.exceptionProperties.getDefaultMappingCode();
    }

    public void setMessagesProvider(MessagesProvider messagesProvider) {
        this.messagesProvider = messagesProvider;
    }

    public void setSystemProperties(SystemProperties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public void setExceptionProperties(ExceptionProperties exceptionProperties) {
        this.exceptionProperties = exceptionProperties;
        this.regex = Pattern.compile(exceptionProperties.getMessageCodeRegex());
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.messagesProvider, (String)"MessagesProvider must not be null.");
        Assert.notNull((Object)this.systemProperties, (String)"SystemProperties must not be null.");
        Assert.notNull((Object)this.exceptionProperties, (String)"ExceptionProperties must not be null.");
    }
}

