/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.exception;

import org.springframework.util.Assert;

public class ErrorDetail {
    private String code;
    private String message;
    private String cause;
    private String hostName;

    private ErrorDetail(Builder builder) {
        this.code = builder.code;
        this.message = builder.message;
        this.cause = builder.cause;
        this.hostName = builder.hostName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCause() {
        return this.cause;
    }

    public String getHostName() {
        return this.hostName;
    }

    public static class Builder {
        private String code;
        private String message;
        private String cause;
        private String hostName;

        private Builder() {
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public ErrorDetail build() {
            Assert.notNull((Object)this.code, (String)"Code must not be null.");
            Assert.notNull((Object)this.message, (String)"Message must not be null.");
            return new ErrorDetail(this);
        }
    }
}

