/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.exception;

import com.cntaiping.ec.cloud.common.exception.TranFailException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;

public class ErrorInfo {
    private static final Map<String, String> ERROR_DEFINED = new ConcurrentHashMap<String, String>();
    private String code;
    private String msg;

    private ErrorInfo(String code, String msg) {
        Assert.isNull((Object)ERROR_DEFINED.get(code), (String)("Error code [" + code + "] repeats definition"));
        this.code = code;
        this.msg = msg;
        ERROR_DEFINED.put(code, msg);
    }

    public static ErrorInfo item(String code, String defaultMsg) {
        return new ErrorInfo(code, defaultMsg);
    }

    public TranFailException initialize() {
        return new TranFailException(this);
    }

    public TranFailException initialize(Object ... args) {
        return new TranFailException(this, args);
    }

    public TranFailException initialize(Throwable th) {
        return new TranFailException(this, th);
    }

    public TranFailException initialize(Throwable th, Object ... args) {
        return new TranFailException(this, th, args);
    }

    public String getCode() {
        return this.code;
    }

    public String getDefaultMsg() {
        return this.msg;
    }
}

