/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.exception;

import java.lang.reflect.InvocationTargetException;
import org.springframework.context.MessageSourceResolvable;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static boolean isWrapped(Throwable th) {
        if (th == null) {
            return false;
        }
        if (th instanceof InvocationTargetException) {
            return true;
        }
        if (!(th instanceof MessageSourceResolvable)) {
            return th.getCause() instanceof MessageSourceResolvable;
        }
        return false;
    }

    public static Throwable unwrapThrowable(Throwable throwable) {
        Throwable causeThrowable;
        while (ExceptionUtil.isWrapped(throwable) && (causeThrowable = throwable.getCause()) != null && causeThrowable != throwable) {
            throwable = causeThrowable;
        }
        return throwable;
    }
}

