/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.exception;

import com.cntaiping.ec.cloud.common.exception.ErrorInfo;

public enum TPSCBPError {
    UNKNOWN("TPSCBP0001", "Unknown system error, please contact system administrator."),
    TIMEOUT("TPSCBP0002", "The system is busy, please check the details and confirm the result."),
    NO_SUCH_ALGORITHM("TPSCBP0003", "No such algorithm."),
    INVALID_ALGORITHM_PARAMETER("TPSCBP0004", "Invalid Algorithm Parameter."),
    CIPHER_ERROR("TPSCBP0005", "An error occurred while using the AES key for decryption/encryption"),
    JSON_ERROR("TPSCBP0006", "An error occurred while JSON serialization/deserialization"),
    CURRENT_USER_NOT_MATCH("TPSCBP0007", "Login user does not match, please use getUser method"),
    RSA_PRIVATEKEY_INSTANCE("TPSCBP0008", "An error occurred while obtaining an instance of RSAPrivateKey"),
    CERTIFICATE_INSTANCE("TPSCBP0009", "An error occurred while obtaining an instance of Certificate"),
    CERTIFICATE_LOADING("TPSCBP0010", "An error occurred while loading Certificate"),
    READING_RSAPRIVATEKEY("TPSCBP0011", "An error occurred reading the RSAPrivateKey"),
    READING_RSAPUBLICKEY("TPSCBP0012", "An error occurred reading the RSAPublicKey"),
    SIGNING("TPSCBP0013", "An error occurred while signing with RSAPrivateKey"),
    VERIFY_SIGN("TPSCBP0014", "An error occurred while using RSAPublicKey to verify the signature"),
    RSA_ENCRYPTION("TPSCBP0015", "An error occurred while using RSAPublicKey for encryption"),
    RSA_DECRYPTION("TPSCBP0016", "An error occurred while decrypting with RSAPrivateKey"),
    MAC_INSTANCE("TPSCBP0017", "An error occurred while getting a MAC instance"),
    HASHING_PASSWORD("TPSCBP0018", "An error occurred while hashing the password"),
    KEYSTORE_INSTANCE("TPSCBP0019", "An error occurred while obtaining an instance of keystore");

    private ErrorInfo errorInfo;

    private TPSCBPError(String code, String defaultMsg) {
        this.errorInfo = ErrorInfo.item(code, defaultMsg);
    }

    public ErrorInfo getInfo() {
        return this.errorInfo;
    }
}

