/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.exception.provider;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.springframework.util.Assert;

public class ErrorStatistics
implements Serializable {
    public static final long serialVersionUID = 1L;
    private String traceNo;
    private String systemCode;
    private String service;
    private String instance;
    private String endpoint;
    private String code;
    private String message;
    private String cause;
    private Date createTime;

    public ErrorStatistics() {
    }

    public ErrorStatistics(Builder builder) {
        this.traceNo = builder.traceNo;
        this.systemCode = builder.systemCode;
        this.service = builder.service;
        this.instance = builder.instance;
        this.endpoint = builder.endpoint;
        this.code = builder.code;
        this.message = builder.message;
        this.cause = builder.cause;
        this.createTime = builder.createTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTraceNo() {
        return this.traceNo;
    }

    public String getSystemCode() {
        return this.systemCode;
    }

    public String getService() {
        return this.service;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCause() {
        return this.cause;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setTraceNo(String traceNo) {
        this.traceNo = traceNo;
    }

    public void setSystemCode(String systemCode) {
        this.systemCode = systemCode;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorStatistics that = (ErrorStatistics)o;
        return Objects.equals(this.traceNo, that.traceNo) && Objects.equals(this.systemCode, that.systemCode) && Objects.equals(this.service, that.service) && Objects.equals(this.instance, that.instance) && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.code, that.code) && Objects.equals(this.message, that.message) && Objects.equals(this.cause, that.cause) && Objects.equals(this.createTime, that.createTime);
    }

    public int hashCode() {
        return Objects.hash(this.traceNo, this.systemCode, this.service, this.instance, this.endpoint, this.code, this.message, this.cause, this.createTime);
    }

    public String toString() {
        return "ErrorStatistics{traceNo='" + this.traceNo + '\'' + ", systemCode='" + this.systemCode + '\'' + ", service='" + this.service + '\'' + ", instance='" + this.instance + '\'' + ", endpoint='" + this.endpoint + '\'' + ", code='" + this.code + '\'' + ", message='" + this.message + '\'' + ", cause='" + this.cause + '\'' + ", createTime=" + this.createTime + '}';
    }

    public static class Builder {
        private String traceNo;
        private String systemCode;
        private String service;
        private String instance;
        private String endpoint;
        private String code;
        private String message;
        private String cause;
        private Date createTime;

        public Builder traceNo(String traceNo) {
            this.traceNo = traceNo;
            return this;
        }

        public Builder systemCode(String systemCode) {
            this.systemCode = systemCode;
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            return this;
        }

        public Builder instance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        public Builder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public ErrorStatistics build() {
            Assert.notNull((Object)this.systemCode, (String)"SystemCode must not be null.");
            Assert.notNull((Object)this.service, (String)"Service must not be null.");
            Assert.notNull((Object)this.code, (String)"Code must not be null.");
            Assert.notNull((Object)this.message, (String)"Message must not be null.");
            Assert.notNull((Object)this.createTime, (String)"CreateTime must not be null.");
            return new ErrorStatistics(this);
        }
    }
}

