/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.exception.provider;

import com.cntaiping.ec.cloud.common.exception.ExceptionProperties;
import com.cntaiping.ec.cloud.common.exception.provider.ErrorStatistics;
import com.cntaiping.ec.cloud.common.exception.provider.ErrorStatisticsProvider;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcErrorStatisticsProvider
implements ErrorStatisticsProvider<ErrorStatistics> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcErrorStatisticsProvider.class);
    private final JdbcTemplate jdbcTemplate;
    private final ExceptionProperties exceptionProperties;

    public JdbcErrorStatisticsProvider(DataSource dataSource, ExceptionProperties exceptionProperties) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.exceptionProperties = exceptionProperties;
    }

    @Override
    public void compute(ErrorStatistics errorStatistics) {
        try {
            this.jdbcTemplate.update(this.exceptionProperties.getStatistics().getJdbc().getTable().getInsertStatement(), new Object[]{this.subString(errorStatistics.getTraceNo(), 360), this.subString(errorStatistics.getSystemCode(), 8), this.subString(errorStatistics.getService(), 36), this.subString(errorStatistics.getInstance(), 120), this.subString(errorStatistics.getEndpoint(), 360), this.subString(errorStatistics.getCode(), 36), this.subString(errorStatistics.getMessage(), 1200), this.subString(errorStatistics.getCause(), 1200), errorStatistics.getCreateTime(), errorStatistics.getCreateTime()}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 91, 91});
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save error statistics.", (Throwable)e);
        }
    }

    private String subString(String str, int len) {
        if (str == null) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }
}

