/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.exception.provider;

import com.cntaiping.ec.cloud.common.exception.ExceptionProperties;
import com.cntaiping.ec.cloud.common.exception.provider.ErrorStatistics;
import com.cntaiping.ec.cloud.common.exception.provider.ErrorStatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaProducerException;
import org.springframework.kafka.core.KafkaSendCallback;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class KafkaErrorStatisticsProvider
implements ErrorStatisticsProvider<ErrorStatistics> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"KafkaErrorStatistics");
    private final KafkaTemplate<String, Object> kafkaTemplate;
    private final ExceptionProperties exceptionProperties;

    public KafkaErrorStatisticsProvider(KafkaTemplate<String, Object> kafkaTemplate, ExceptionProperties exceptionProperties) {
        this.kafkaTemplate = kafkaTemplate;
        this.exceptionProperties = exceptionProperties;
    }

    @Override
    public void compute(ErrorStatistics errorStatistics) {
        ListenableFuture future = this.kafkaTemplate.send(this.exceptionProperties.getStatistics().getKafka().getTopic(), (Object)errorStatistics.getTraceNo(), (Object)errorStatistics);
        future.addCallback((ListenableFutureCallback)new KafkaSendCallback<String, Object>(){

            public void onSuccess(SendResult<String, Object> sendResult) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Send message [{}] successfully.", sendResult);
                }
            }

            public void onFailure(KafkaProducerException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Send message [{}] failure.", (Object)e.getFailedProducerRecord());
                }
            }
        });
    }
}

