/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.fmt;

import com.cntaiping.ec.cloud.common.exception.ResultFailException;
import com.cntaiping.ec.cloud.common.exception.ServiceType;
import com.cntaiping.ec.cloud.common.fmt.GeneralResponse;
import com.cntaiping.ec.cloud.common.fmt.InternalRequestMapping;
import com.cntaiping.ec.cloud.common.fmt.InternalServiceType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonInputMessage;

public class InternalRequestMessageConverter
extends AbstractJackson2HttpMessageConverter {
    public InternalRequestMessageConverter(ObjectMapper objectMapper) {
        super(objectMapper, InternalRequestMapping.INTERNAL_MIME);
    }

    protected MediaType getDefaultContentType(Object object) throws IOException {
        return InternalRequestMapping.INTERNAL_MIME;
    }

    protected boolean canRead(MediaType mediaType) {
        return InternalRequestMapping.INTERNAL_MIME.isCompatibleWith(mediaType);
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        JavaType retType = this.getJavaType(type, contextClass);
        Class cls = retType.getRawClass();
        if (GeneralResponse.class.isAssignableFrom(cls)) {
            GeneralResponse response = (GeneralResponse)this.readJavaType(retType, inputMessage);
            if (!response.isSuccess()) {
                throw new ResultFailException((ServiceType)InternalServiceType.INTERNAL_API, response.getCode(), response.getDesc(), (Object)response, null);
            }
            return response;
        }
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        JavaType javaType = typeFactory.constructParametricType(GeneralResponse.class, new JavaType[]{retType});
        GeneralResponse response = null;
        try {
            response = (GeneralResponse)this.readJavaType(javaType, inputMessage);
        }
        catch (Exception e) {
            return this.readJavaType(retType, inputMessage);
        }
        if (!response.isSuccess()) {
            throw new ResultFailException((ServiceType)InternalServiceType.INTERNAL_API, response.getCode(), response.getDesc(), (Object)response, null);
        }
        return response.getData();
    }

    private Object readJavaType(JavaType javaType, HttpInputMessage inputMessage) throws IOException {
        try {
            Class deserializationView;
            if (inputMessage instanceof MappingJacksonInputMessage && (deserializationView = ((MappingJacksonInputMessage)inputMessage).getDeserializationView()) != null) {
                return this.objectMapper.readerWithView(deserializationView).forType(javaType).readValue(inputMessage.getBody());
            }
            return this.objectMapper.readValue(inputMessage.getBody(), javaType);
        }
        catch (InvalidDefinitionException ex) {
            throw new HttpMessageConversionException("Type definition error: " + ex.getType(), (Throwable)ex);
        }
        catch (JsonProcessingException ex) {
            throw new HttpMessageNotReadableException("JSON parse error: " + ex.getOriginalMessage(), (Throwable)ex, inputMessage);
        }
    }
}

