/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.log;

import com.cntaiping.ec.cloud.common.core.Context;
import com.cntaiping.ec.cloud.common.core.ContextUtils;
import com.cntaiping.ec.cloud.common.exception.BaseRuntimeException;
import com.cntaiping.ec.cloud.common.exception.ExceptionUtil;
import com.cntaiping.ec.cloud.common.exception.TPSCBPError;
import com.cntaiping.ec.cloud.common.log.LogInfo;
import com.cntaiping.ec.cloud.common.log.LogProcessor;
import com.cntaiping.ec.cloud.common.session.SessionIdUtils;
import com.cntaiping.ec.cloud.common.utils.id.UUID62;
import com.cntaiping.ec.cloud.common.utils.trace.TraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSourceResolvable;

public class BaseLogProcessor<Log extends LogInfo>
implements LogProcessor<Log> {
    protected Logger logger = LoggerFactory.getLogger(BaseLogProcessor.class);

    @Override
    public Log newLog() {
        LogInfo log = new LogInfo();
        log.init();
        log.setLogNo(UUID62.randomUUID62());
        return (Log)log;
    }

    @Override
    public void save(Log logInfo) {
        this.logger.info("Save Log::{}", logInfo);
    }

    @Override
    public void preHandle(Log logInfo, Object request) {
        ((LogInfo)logInfo).setSuccess(true);
        this.logBaseInfo(logInfo);
    }

    @Override
    public void before(Log logInfo, Object request) {
        this.logBaseInfo(logInfo);
    }

    private void logBaseInfo(Log logInfo) {
        Context context = ContextUtils.get();
        if (context == null) {
            return;
        }
        ((LogInfo)logInfo).setChannel((String)context.getAttribute("x-channel"));
        ((LogInfo)logInfo).setEndpoint(context.getEndpoint());
        ((LogInfo)logInfo).setSessionId(SessionIdUtils.get());
        ((LogInfo)logInfo).setTraceNo(TraceUtils.get());
        ((LogInfo)logInfo).setSource((String)context.getAttribute("x-source"));
        this.logUser(logInfo, context);
    }

    @Override
    public void after(Log logInfo, Object response, Throwable th) {
        Context context = ContextUtils.get();
        if (context != null) {
            this.logUser(logInfo, context);
        }
        this.logError(logInfo, context, th);
    }

    @Override
    public void afterCompletion(Log logInfo, Object response, Throwable th) {
        Context context = ContextUtils.get();
        this.logError(logInfo, context, th);
    }

    protected void logUser(Log logInfo, Context context) {
        Object user = context.getUser();
        if (user != null) {
            ((LogInfo)logInfo).setUserId(user.getUserId());
            ((LogInfo)logInfo).setCifId(user.getCifId());
        }
    }

    protected void logError(Log logInfo, Context context, Throwable th) {
        th = ExceptionUtil.unwrapThrowable(th);
        if (((LogInfo)logInfo).isSuccess() && th != null) {
            ((LogInfo)logInfo).setSuccess(false);
            if (th instanceof BaseRuntimeException) {
                BaseRuntimeException bre = (BaseRuntimeException)th;
                ((LogInfo)logInfo).setCode(bre.getCode());
                ((LogInfo)logInfo).setMessage(bre.getMessage());
                ((LogInfo)logInfo).setCause(bre.getDefaultMessage());
            } else if (th instanceof MessageSourceResolvable) {
                MessageSourceResolvable msr = (MessageSourceResolvable)th;
                String[] codes = msr.getCodes();
                if (codes != null) {
                    ((LogInfo)logInfo).setCode(codes[0]);
                }
                ((LogInfo)logInfo).setMessage(msr.getDefaultMessage());
                ((LogInfo)logInfo).setCause(msr.getDefaultMessage());
            } else {
                ((LogInfo)logInfo).setCode(TPSCBPError.UNKNOWN.getInfo().getCode());
                ((LogInfo)logInfo).setMessage(th.getMessage());
                ((LogInfo)logInfo).setCause(th.getCause() != null ? th.getCause().getMessage() : th.getMessage());
            }
        }
    }
}

