/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.log;

import com.cntaiping.ec.cloud.common.core.ContextUtils;
import com.cntaiping.ec.cloud.common.log.LogInfo;
import com.cntaiping.ec.cloud.common.log.LogUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=0x7FFFFFFF)
public class LogAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogAspect.class);

    @Pointcut(value="@annotation(com.cntaiping.ec.cloud.common.log.Log)")
    public void pointcut() {
    }

    @Before(value="pointcut()")
    public void before(JoinPoint joinPoint) {
        LOGGER.debug("Before log advice executing...");
        LogInfo logInfo = LogUtils.current(false);
        if (logInfo == null) {
            logInfo = LogUtils.current(true);
            logInfo.setSavePoint(LogInfo.SavePoint.Aspect);
        }
        LogUtils.logProcessor().before(logInfo, ContextUtils.get());
    }

    @AfterReturning(value="pointcut()")
    public void afterReturning(JoinPoint joinPoint) {
        LOGGER.debug("Before afterReturning advice executing...");
        this.logError(null);
    }

    @AfterThrowing(value="pointcut()", throwing="ex")
    public void afterThrowing(JoinPoint joinPoint, Exception ex) {
        LOGGER.debug("Before afterThrowing advice executing...");
        this.logError(ex);
    }

    private void logError(Throwable th) {
        try {
            LogInfo log = LogUtils.current(false);
            if (log != null) {
                LogUtils.logProcessor().after(log, ContextUtils.get(), th);
                if (log.getSavePoint() == LogInfo.SavePoint.Aspect) {
                    LogUtils.save();
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save log", (Throwable)e);
        }
    }
}

