/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.log;

import com.cntaiping.ec.cloud.common.SystemProperties;
import com.cntaiping.ec.cloud.common.core.ContextUtils;
import com.cntaiping.ec.cloud.common.log.LogInfo;
import com.cntaiping.ec.cloud.common.log.LogUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class LogHandlerInterceptor
extends HandlerInterceptorAdapter {
    private final SystemProperties systemProperties;

    public LogHandlerInterceptor(SystemProperties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        LogInfo logInfo = LogUtils.current(true);
        if (logInfo != null) {
            logInfo.setSystemCode(this.systemProperties.getSystemCode());
            logInfo.setService(this.systemProperties.getSystemName());
            logInfo.setInstance(this.systemProperties.getHostName());
            LogUtils.logProcessor().preHandle(logInfo, ContextUtils.get());
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) throws Exception {
        LogInfo logInfo;
        if (modelAndView != null && (logInfo = LogUtils.current(false)) != null) {
            logInfo.additionInfo("viewName", modelAndView.getViewName());
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
        try {
            LogInfo logInfo = LogUtils.current(false);
            if (logInfo != null && logInfo.getSavePoint() == LogInfo.SavePoint.Interceptor) {
                LogUtils.logProcessor().afterCompletion(logInfo, ContextUtils.get(), ex);
                LogUtils.save();
            }
        }
        catch (Exception e) {
            LogUtils.clear();
        }
    }
}

