/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.log;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LogInfo
implements Serializable {
    public static final long serialVersionUID = 1L;
    private volatile boolean record = false;
    private SavePoint savePoint;
    private String logNo;
    private String traceNo;
    private String sessionId;
    private String channel;
    private String source;
    private List<String> hostCode;
    private String userId;
    private String cifId;
    private String systemCode;
    private String service;
    private String instance;
    private String endpoint;
    private long timing;
    private boolean success;
    private String code;
    private String message;
    private String cause;
    private Date createTime;
    private Map<String, Object> additionInfo;

    public void init() {
        this.savePoint = SavePoint.Interceptor;
        this.createTime = new Date();
        this.hostCode = new ArrayList<String>();
        this.additionInfo = new HashMap<String, Object>();
        this.success = false;
    }

    public void record() {
        this.timing = System.currentTimeMillis() - this.createTime.getTime();
        this.record = true;
    }

    public boolean isRecord() {
        return this.record;
    }

    public void setRecord(boolean record) {
        this.record = record;
    }

    public SavePoint getSavePoint() {
        return this.savePoint;
    }

    public void setSavePoint(SavePoint savePoint) {
        this.savePoint = savePoint;
    }

    public String getLogNo() {
        return this.logNo;
    }

    public void setLogNo(String logNo) {
        this.logNo = logNo;
    }

    public String getTraceNo() {
        return this.traceNo;
    }

    public void setTraceNo(String traceNo) {
        this.traceNo = traceNo;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public List<String> getHostCode() {
        return this.hostCode;
    }

    public void setHostCode(List<String> hostCode) {
        this.hostCode = hostCode;
    }

    public void addHostCode(String hostCode) {
        this.hostCode.add(hostCode);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getCifId() {
        return this.cifId;
    }

    public void setCifId(String cifId) {
        this.cifId = cifId;
    }

    public String getSystemCode() {
        return this.systemCode;
    }

    public void setSystemCode(String systemCode) {
        this.systemCode = systemCode;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public long getTiming() {
        return this.timing;
    }

    public void setTiming(long timing) {
        this.timing = timing;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCause() {
        return this.cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Map<String, Object> getAdditionInfo() {
        return this.additionInfo;
    }

    public void setAdditionInfo(Map<String, Object> additionInfo) {
        this.additionInfo = additionInfo;
    }

    public void additionInfo(String name, Object value) {
        this.additionInfo.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogInfo logInfo = (LogInfo)o;
        return this.logNo.equals(logInfo.logNo);
    }

    public int hashCode() {
        return Objects.hash(this.logNo);
    }

    public String toString() {
        return "LogInfo{record=" + this.record + ", savePoint=" + (Object)((Object)this.savePoint) + ", logNo='" + this.logNo + '\'' + ", traceNo='" + this.traceNo + '\'' + ", sessionId='" + this.sessionId + '\'' + ", channel='" + this.channel + '\'' + ", source='" + this.source + '\'' + ", hostCode='" + this.hostCode + '\'' + ", userId='" + this.userId + '\'' + ", cifId='" + this.cifId + '\'' + ", systemCode='" + this.systemCode + '\'' + ", service='" + this.service + '\'' + ", instance='" + this.instance + '\'' + ", endpoint='" + this.endpoint + '\'' + ", timing=" + this.timing + ", success=" + this.success + ", code='" + this.code + '\'' + ", message='" + this.message + '\'' + ", cause='" + this.cause + '\'' + ", createTime=" + this.createTime + ", additionInfo=" + this.additionInfo + '}';
    }

    public static enum SavePoint {
        Filter,
        Interceptor,
        Aspect;

    }
}

