/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.log;

import com.cntaiping.ec.cloud.common.log.LogInfo;
import com.cntaiping.ec.cloud.common.log.LogProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogUtils.class);
    private static final ThreadLocal<LogInfo> LOG_INFO_THREAD_LOCAL = new InheritableThreadLocal<LogInfo>();
    private static LogProcessor<LogInfo> LOG_PROCESSOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogProcessor(LogProcessor<LogInfo> logProcessor) {
        LogUtils logUtils = this;
        synchronized (logUtils) {
            LOG_PROCESSOR = logProcessor;
        }
    }

    public static LogInfo current(boolean createNew) {
        LogInfo log = LOG_INFO_THREAD_LOCAL.get();
        if (log == null && createNew) {
            log = LOG_PROCESSOR.newLog();
            LOG_INFO_THREAD_LOCAL.set(log);
        }
        return log;
    }

    public static LogProcessor<LogInfo> logProcessor() {
        return LOG_PROCESSOR;
    }

    public static void clear() {
        LOG_INFO_THREAD_LOCAL.remove();
    }

    public static void save() {
        LogInfo log = LOG_INFO_THREAD_LOCAL.get();
        try {
            if (log != null && !log.isRecord() && LOG_PROCESSOR != null) {
                log.record();
                LOG_PROCESSOR.save(log);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save log", (Throwable)e);
        }
        finally {
            LogUtils.clear();
        }
    }
}

