/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.log.processor;

import com.cntaiping.ec.cloud.common.log.BaseLogProcessor;
import com.cntaiping.ec.cloud.common.log.LogInfo;
import com.cntaiping.ec.cloud.common.log.LogProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaProducerException;
import org.springframework.kafka.core.KafkaSendCallback;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class KafkaLogProcessor
extends BaseLogProcessor<LogInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"KafkaLogProcessor");
    private final KafkaTemplate<String, Object> kafkaTemplate;
    private final LogProperties logProperties;

    public KafkaLogProcessor(KafkaTemplate<String, Object> kafkaTemplate, LogProperties logProperties) {
        this.kafkaTemplate = kafkaTemplate;
        this.logProperties = logProperties;
    }

    @Override
    public void save(LogInfo logInfo) {
        ListenableFuture future = this.kafkaTemplate.send(this.logProperties.getKafka().getTopic(), (Object)logInfo.getLogNo(), (Object)logInfo);
        future.addCallback((ListenableFutureCallback)new KafkaSendCallback<String, Object>(){

            public void onSuccess(SendResult<String, Object> sendResult) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Send message [{}] successfully.", sendResult);
                }
            }

            public void onFailure(KafkaProducerException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Send message [{}] failure.", (Object)e.getFailedProducerRecord());
                }
            }
        });
    }
}

