/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.log.processor;

import com.cntaiping.ec.cloud.common.log.BaseLogProcessor;
import com.cntaiping.ec.cloud.common.log.LogInfo;
import com.cntaiping.ec.cloud.common.log.LogProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitLogProcessor
extends BaseLogProcessor<LogInfo> {
    private final RabbitTemplate rabbitTemplate;
    private final LogProperties logProperties;

    public RabbitLogProcessor(RabbitTemplate rabbitTemplate, LogProperties logProperties) {
        this.rabbitTemplate = rabbitTemplate;
        this.logProperties = logProperties;
    }

    @Override
    public void save(LogInfo logInfo) {
        this.rabbitTemplate.convertAndSend(this.logProperties.getRabbit().getExchange(), this.logProperties.getRabbit().getRoutingKey(), (Object)logInfo);
    }
}

