/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.messagesource;

import com.cntaiping.ec.cloud.common.messagesource.ApolloSettings;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.google.common.base.Strings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.AbstractResourceBasedMessageSource;
import org.springframework.lang.Nullable;

public class ApolloMessageSource
extends AbstractResourceBasedMessageSource
implements InitializingBean {
    private boolean concurrentRefresh = true;
    private final ConcurrentMap<String, Map<Locale, List<String>>> cachedNamespaces = new ConcurrentHashMap<String, Map<Locale, List<String>>>();
    private final ConcurrentMap<String, NamespaceHolder> cachedProperties = new ConcurrentHashMap<String, NamespaceHolder>();
    private final ApolloSettings apolloSettings;

    public ApolloMessageSource(ApolloSettings settings) {
        String env;
        String appId;
        String apolloMeta;
        this.apolloSettings = settings;
        String apolloCluster = settings.getApolloCluster();
        if (!Strings.isNullOrEmpty((String)apolloCluster)) {
            System.setProperty("apollo.cluster", apolloCluster);
        }
        if (!Strings.isNullOrEmpty((String)(apolloMeta = settings.getApolloMeta()))) {
            System.setProperty("apollo.meta", apolloMeta);
        }
        if (!Strings.isNullOrEmpty((String)(appId = settings.getAppId()))) {
            System.setProperty("app.id", appId);
        }
        if (!Strings.isNullOrEmpty((String)(env = settings.getApolloEnv()))) {
            System.setProperty("env", env);
        }
    }

    public void setConcurrentRefresh(boolean concurrentRefresh) {
        this.concurrentRefresh = concurrentRefresh;
    }

    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        for (String basename : this.getBasenameSet()) {
            List<String> namespaces = this.calculateAllNamespaces(basename, locale);
            for (String namespace : namespaces) {
                NamespaceHolder namespaceHolder = this.getProperties(namespace);
                String result = namespaceHolder.getProperty(code);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        for (String basename : this.getBasenameSet()) {
            List<String> namespaces = this.calculateAllNamespaces(basename, locale);
            for (String namespace : namespaces) {
                NamespaceHolder namespaceHolder = this.getProperties(namespace);
                MessageFormat result = namespaceHolder.getMessageFormat(code, locale);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    protected List<String> calculateAllNamespaces(String basename, Locale locale) {
        Map existing;
        ArrayList<String> namespaces;
        Map<Locale, ArrayList<String>> localeMap = (ConcurrentHashMap<Locale, ArrayList<String>>)this.cachedNamespaces.get(basename);
        if (localeMap != null && (namespaces = (ArrayList<String>)localeMap.get(locale)) != null) {
            return namespaces;
        }
        namespaces = new ArrayList<String>(7);
        namespaces.addAll(this.calculateNamespacesForLocale(basename, locale));
        Locale defaultLocale = this.getDefaultLocale();
        if (defaultLocale != null && !defaultLocale.equals(locale)) {
            List<String> fallbackNamespaces = this.calculateNamespacesForLocale(basename, defaultLocale);
            for (String fallbackNamespace : fallbackNamespaces) {
                if (namespaces.contains(fallbackNamespace)) continue;
                namespaces.add(fallbackNamespace);
            }
        }
        namespaces.add(basename);
        if (localeMap == null && (existing = (Map)this.cachedNamespaces.putIfAbsent(basename, localeMap = new ConcurrentHashMap<Locale, ArrayList<String>>())) != null) {
            localeMap = existing;
        }
        localeMap.put(locale, namespaces);
        return namespaces;
    }

    protected List<String> calculateNamespacesForLocale(String basename, Locale locale) {
        ArrayList<String> result = new ArrayList<String>(3);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder temp = new StringBuilder(basename);
        temp.append('_');
        if (language.length() > 0) {
            temp.append(language);
            result.add(0, temp.toString());
        }
        temp.append('_');
        if (country.length() > 0) {
            temp.append(country);
            result.add(0, temp.toString());
        }
        if (variant.length() > 0 && (language.length() > 0 || country.length() > 0)) {
            temp.append('_').append(variant);
            result.add(0, temp.toString());
        }
        return result;
    }

    protected NamespaceHolder getProperties(String namespace) {
        NamespaceHolder namespaceHolder = (NamespaceHolder)this.cachedProperties.get(namespace);
        if (namespaceHolder != null) {
            return namespaceHolder;
        }
        namespaceHolder = new NamespaceHolder();
        this.cachedProperties.putIfAbsent(namespace, namespaceHolder);
        return namespaceHolder;
    }

    protected NamespaceHolder loadProperties(String namespace) {
        NamespaceHolder namespaceHolder;
        block3: {
            namespaceHolder = new NamespaceHolder();
            try {
                Config config = ConfigService.getConfig((String)namespace);
                config.addChangeListener(changeEvent -> {
                    for (String changeKey : changeEvent.changedKeys()) {
                        ConfigChange eventChange = changeEvent.getChange(changeKey);
                        if (eventChange.getChangeType() == PropertyChangeType.DELETED) {
                            namespaceHolder.getProperties().remove(eventChange.getPropertyName());
                            continue;
                        }
                        namespaceHolder.getProperties().put(eventChange.getPropertyName(), eventChange.getNewValue());
                    }
                });
                ConcurrentHashMap<String, String> properties = new ConcurrentHashMap<String, String>();
                Set propertyNames = config.getPropertyNames();
                for (String propertyName : propertyNames) {
                    String propertyValue = config.getProperty(propertyName, null);
                    properties.put(propertyName, propertyValue);
                }
                namespaceHolder.getProperties().putAll(properties);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block3;
                this.logger.warn((Object)("Could not get properties from namespace [" + namespace + "]"), (Throwable)e);
            }
        }
        namespaceHolder.setInit(true);
        this.cachedProperties.put(namespace, namespaceHolder);
        return namespaceHolder;
    }

    public void clearCache() {
        this.logger.debug((Object)"Clearing entire resource bundle cache");
        this.cachedProperties.clear();
    }

    public void clearCacheIncludingAncestors() {
        this.clearCache();
        if (this.getParentMessageSource() instanceof ApolloMessageSource) {
            ((ApolloMessageSource)this.getParentMessageSource()).clearCacheIncludingAncestors();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ": basenames=" + this.getBasenameSet();
    }

    public void afterPropertiesSet() throws Exception {
        try {
            LinkedHashSet<String> namespaces = new LinkedHashSet<String>();
            for (String basename : this.getBasenameSet()) {
                for (String locale : this.apolloSettings.getLocales()) {
                    namespaces.add(basename + "_" + locale);
                }
                namespaces.add(basename);
            }
            CountDownLatch countDownLatch = new CountDownLatch(namespaces.size());
            for (String namespace : namespaces) {
                new Thread(() -> {
                    NamespaceHolder namespaceHolder = this.loadProperties(namespace);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("init namespace[" + namespace + "], properties:[" + namespaceHolder + "]"));
                    }
                    countDownLatch.countDown();
                }).start();
            }
            countDownLatch.await(1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            this.logger.error((Object)"load properties from apollo failed.", (Throwable)e);
        }
    }

    protected class NamespaceHolder {
        private final Map<String, String> properties;
        private final ReentrantLock refreshLock = new ReentrantLock();
        private volatile boolean init = false;
        private final ConcurrentMap<String, Map<Locale, MessageFormat>> cachedMessageFormats = new ConcurrentHashMap<String, Map<Locale, MessageFormat>>();

        public NamespaceHolder() {
            this.properties = new ConcurrentHashMap<String, String>();
        }

        public boolean isInit() {
            return this.init;
        }

        public void setInit(boolean init) {
            this.init = init;
        }

        public NamespaceHolder(Map<String, String> properties) {
            this.properties = properties;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        @Nullable
        public String getProperty(String code) {
            if (this.properties == null) {
                return null;
            }
            return this.properties.get(code);
        }

        @Nullable
        public MessageFormat getMessageFormat(String code, Locale locale) {
            MessageFormat result;
            if (this.properties == null) {
                return null;
            }
            Map<Locale, MessageFormat> localeMap = (ConcurrentHashMap<Locale, MessageFormat>)this.cachedMessageFormats.get(code);
            if (localeMap != null && (result = (MessageFormat)localeMap.get(locale)) != null) {
                return result;
            }
            String msg = this.properties.get(code);
            if (msg != null) {
                Map existing;
                if (localeMap == null && (existing = (Map)this.cachedMessageFormats.putIfAbsent(code, localeMap = new ConcurrentHashMap<Locale, MessageFormat>())) != null) {
                    localeMap = existing;
                }
                MessageFormat result2 = ApolloMessageSource.this.createMessageFormat(msg, locale);
                localeMap.put(locale, result2);
                return result2;
            }
            return null;
        }

        public String toString() {
            return "NamespaceHolder{properties=" + this.properties + '}';
        }
    }
}

