/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.messagesource;

import com.cntaiping.ec.cloud.common.messagesource.MessageSourceLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class DefaultEnvironmentMessageSourceLoader
implements MessageSourceLoader,
EnvironmentAware,
ApplicationListener<EnvironmentChangeEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEnvironmentMessageSourceLoader.class);
    private final Map<String, Date> lastModifiedMap = new ConcurrentHashMap<String, Date>();
    private Environment environment;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> loadMessageSource(String key, String locale) {
        String propertyName = this.getPropertyName(key, locale);
        String propertyValue = this.environment.getProperty(propertyName);
        LOGGER.debug("Get property value [{}] with property name [{}]", (Object)propertyValue, (Object)propertyName);
        if (propertyValue == null) {
            return new HashMap<String, String>();
        }
        try (InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(propertyValue.getBytes()));){
            HashMap<String, String> retMap = new HashMap<String, String>();
            Properties properties = new Properties();
            properties.load(isr);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                retMap.put(entry.getKey().toString(), entry.getValue().toString());
            }
            HashMap<String, String> hashMap = retMap;
            return hashMap;
        }
        catch (Exception e) {
            LOGGER.warn("load properties failed::key==>[{}]", (Object)propertyName, (Object)e);
            return new HashMap<String, String>();
        }
    }

    @Override
    public Date lastModified(String key, String locale) {
        String propertyName = this.getPropertyName(key, locale);
        String propertyValue = this.environment.getProperty(propertyName);
        if (propertyValue == null) {
            this.lastModifiedMap.remove(propertyName);
            return null;
        }
        Date lastModified = this.lastModifiedMap.get(propertyName);
        if (lastModified == null) {
            lastModified = new Date();
            this.lastModifiedMap.put(propertyName, lastModified);
            return lastModified;
        }
        return lastModified;
    }

    protected String getPropertyName(String key, String locale) {
        return key + "." + locale;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        Set keys = event.getKeys();
        Date lastModified = new Date(event.getTimestamp());
        for (String key : keys) {
            if (!this.lastModifiedMap.containsKey(key)) continue;
            LOGGER.debug("change key [{}] lastModified [{}]", (Object)key, (Object)lastModified);
            this.lastModifiedMap.put(key, lastModified);
        }
    }
}

