/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.messagesource;

import com.cntaiping.ec.cloud.common.messagesource.MessageSourceLoader;
import com.cntaiping.ec.cloud.common.messagesource.MessageSourcePersistenceObject;
import com.cntaiping.ec.cloud.common.messagesource.MessageSourceTable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

public class DefaultJdbcMessageSourceLoader
implements MessageSourceLoader,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJdbcMessageSourceLoader.class);
    private final JdbcTemplate jdbcTemplate;
    private final MessageSourceTable messageSourceTable;

    public DefaultJdbcMessageSourceLoader(DataSource dataSource, MessageSourceTable messageSourceTable) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.messageSourceTable = messageSourceTable;
    }

    @Override
    public Map<String, String> loadMessageSource(String tableName, String locale) {
        MessageSourceTable target = this.messageSourceTable.copy(tableName);
        try {
            List messageSourcePersistenceObjects = this.jdbcTemplate.query(target.getSelectMessageSourcesByLocaleStatement(), new Object[]{locale}, (resultSet, i) -> {
                MessageSourcePersistenceObject ms = new MessageSourcePersistenceObject();
                ms.setId(resultSet.getLong(target.getIdColumn()));
                ms.setLocale(resultSet.getString(target.getLocaleColumn()));
                ms.setCode(resultSet.getString(target.getCodeColumn()));
                ms.setMessage(resultSet.getString(target.getMessageColumn()));
                ms.setCreateTime(resultSet.getDate(target.getCreateTimeColumn()));
                ms.setUpdateTime(resultSet.getDate(target.getUpdateTimeColumn()));
                return ms;
            });
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>(16);
            for (MessageSourcePersistenceObject message : messageSourcePersistenceObjects) {
                map.put(message.getCode(), message.getMessage());
            }
            return map;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load MessageSource: [{}] [{}]", new Object[]{target.getSelectMessageSourcesByLocaleStatement(), locale, e});
            return null;
        }
    }

    @Override
    public Date lastModified(String tableName, String locale) {
        MessageSourceTable target = this.messageSourceTable.copy(tableName);
        try {
            return (Date)this.jdbcTemplate.queryForObject(target.getSelectLastModifiedStatement(), new Object[]{locale}, Date.class);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to select LastModified: [{}] [{}]", new Object[]{target.getSelectLastModifiedStatement(), locale, e});
            return null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jdbcTemplate, (String)"JdbcTemplate must not be null.");
        Assert.notNull((Object)this.messageSourceTable, (String)"MessageSourceTable must not be null.");
    }
}

