/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.messagesource;

import com.cntaiping.ec.cloud.common.messagesource.MessageSourceLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.context.MessageSource;
import org.springframework.context.support.AbstractResourceBasedMessageSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ReloadablePropertiesMessageSource
extends AbstractResourceBasedMessageSource {
    private boolean concurrentRefresh = true;
    private final ConcurrentMap<String, Map<Locale, List<Param>>> cachedPropertyParams = new ConcurrentHashMap<String, Map<Locale, List<Param>>>();
    private final ConcurrentMap<Param, PropertyHolder> cachedProperty = new ConcurrentHashMap<Param, PropertyHolder>();
    private final ConcurrentMap<Locale, PropertyHolder> cachedMergedProperty = new ConcurrentHashMap<Locale, PropertyHolder>();
    private final MessageSourceLoader messageSourceLoader;

    public ReloadablePropertiesMessageSource(MessageSourceLoader messageSourceLoader) {
        this.messageSourceLoader = messageSourceLoader;
    }

    public void setConcurrentRefresh(boolean concurrentRefresh) {
        this.concurrentRefresh = concurrentRefresh;
    }

    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        if (this.getCacheMillis() < 0L) {
            PropertyHolder propertyHolder = this.getMergedProperty(locale);
            return propertyHolder.getMessage(code);
        }
        for (String basename : this.getBasenameSet()) {
            List<Param> params = this.calculateAllPropertyParams(basename, locale);
            for (Param param : params) {
                PropertyHolder propertyHolder = this.getProperty(param);
                String result = propertyHolder.getMessage(code);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        if (this.getCacheMillis() < 0L) {
            PropertyHolder propertyHolder = this.getMergedProperty(locale);
            return propertyHolder.getMessageFormat(code, locale);
        }
        for (String basename : this.getBasenameSet()) {
            List<Param> params = this.calculateAllPropertyParams(basename, locale);
            for (Param param : params) {
                PropertyHolder propertyHolder = this.getProperty(param);
                MessageFormat result = propertyHolder.getMessageFormat(code, locale);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyHolder getProperty(Param param) {
        PropertyHolder existingHolder;
        PropertyHolder propertyHolder = (PropertyHolder)this.cachedProperty.get(param);
        long originalTimestamp = -2L;
        if (propertyHolder != null) {
            originalTimestamp = propertyHolder.getRefreshTimestamp();
            if (originalTimestamp == -1L || originalTimestamp > System.currentTimeMillis() - this.getCacheMillis()) {
                return propertyHolder;
            }
        } else {
            propertyHolder = new PropertyHolder();
            existingHolder = this.cachedProperty.putIfAbsent(param, propertyHolder);
            if (existingHolder != null) {
                propertyHolder = existingHolder;
            }
        }
        if (this.concurrentRefresh && propertyHolder.getRefreshTimestamp() >= 0L) {
            if (!propertyHolder.refreshLock.tryLock()) {
                return propertyHolder;
            }
        } else {
            propertyHolder.refreshLock.lock();
        }
        try {
            existingHolder = (PropertyHolder)this.cachedProperty.get(param);
            if (existingHolder != null && existingHolder.getRefreshTimestamp() > originalTimestamp) {
                PropertyHolder propertyHolder2 = existingHolder;
                return propertyHolder2;
            }
            PropertyHolder propertyHolder3 = this.refreshProperty(param, propertyHolder);
            return propertyHolder3;
        }
        finally {
            propertyHolder.refreshLock.unlock();
        }
    }

    protected PropertyHolder refreshProperty(Param param, @Nullable PropertyHolder propertyHolder) {
        Assert.notNull((Object)this.messageSourceLoader, (String)"MessageSourceLoader must not be null.");
        long refreshTimestamp = this.getCacheMillis() < 0L ? -1L : System.currentTimeMillis();
        Date lastModified = this.messageSourceLoader.lastModified(param.getKey(), param.getLocale());
        if (lastModified != null) {
            if (this.getCacheMillis() >= 0L && propertyHolder != null && lastModified.getTime() == propertyHolder.getParamTimestamp()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Re-caching property for param [" + param + "] - property hasn't been modified"));
                }
                propertyHolder.setRefreshTimestamp(refreshTimestamp);
                return propertyHolder;
            }
            try {
                Map<String, String> source = this.messageSourceLoader.loadMessageSource(param.getKey(), param.getLocale());
                propertyHolder = new PropertyHolder(source, lastModified.getTime());
            }
            catch (Exception e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Could load source [" + param + "]"), (Throwable)e);
                }
                propertyHolder = new PropertyHolder();
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No property found for [" + param + "]"));
            }
            propertyHolder = new PropertyHolder();
        }
        propertyHolder.setRefreshTimestamp(refreshTimestamp);
        this.cachedProperty.put(param, propertyHolder);
        return propertyHolder;
    }

    protected List<Param> calculateAllPropertyParams(String basename, Locale locale) {
        Map existing;
        ArrayList<Param> params;
        Map<Locale, ArrayList<Param>> localeMap = (ConcurrentHashMap<Locale, ArrayList<Param>>)this.cachedPropertyParams.get(basename);
        if (localeMap != null && (params = (ArrayList<Param>)localeMap.get(locale)) != null) {
            return params;
        }
        params = new ArrayList<Param>(6);
        params.addAll(this.calculatePropertyParamsForLocale(basename, locale));
        Locale defaultLocale = this.getDefaultLocale();
        if (defaultLocale != null && !locale.equals(defaultLocale)) {
            List<Param> fallbackParams = this.calculatePropertyParamsForLocale(basename, defaultLocale);
            for (Param fallbackParam : fallbackParams) {
                if (params.contains(fallbackParam)) continue;
                params.add(fallbackParam);
            }
        }
        if (localeMap == null && (existing = (Map)this.cachedPropertyParams.putIfAbsent(basename, localeMap = new ConcurrentHashMap<Locale, ArrayList<Param>>(2))) != null) {
            localeMap = existing;
        }
        localeMap.put(locale, params);
        return params;
    }

    protected List<Param> calculatePropertyParamsForLocale(String basename, Locale locale) {
        ArrayList<Param> result = new ArrayList<Param>(3);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder temp = new StringBuilder();
        if (language.length() > 0) {
            temp.append(language);
            result.add(0, new Param(basename, temp.toString()));
        }
        temp.append('_');
        if (country.length() > 0) {
            temp.append(country);
            result.add(0, new Param(basename, temp.toString()));
        }
        if (variant.length() > 0 && (language.length() > 0 || country.length() > 0)) {
            temp.append('_').append(variant);
            result.add(0, new Param(basename, temp.toString()));
        }
        return result;
    }

    protected PropertyHolder getMergedProperty(Locale locale) {
        PropertyHolder mergedHolder = (PropertyHolder)this.cachedMergedProperty.get(locale);
        if (mergedHolder != null) {
            return mergedHolder;
        }
        ConcurrentHashMap<String, String> mergedMap = new ConcurrentHashMap<String, String>();
        long latestTimestamp = -1L;
        String[] basenames = StringUtils.toStringArray((Collection)this.getBasenameSet());
        for (int i = basenames.length - 1; i >= 0; --i) {
            List<Param> params = this.calculateAllPropertyParams(basenames[i], locale);
            for (int j = params.size() - 1; j >= 0; --j) {
                Param param = params.get(j);
                PropertyHolder propertyHolder = this.getProperty(param);
                if (propertyHolder.getSource() == null) continue;
                mergedMap.putAll(propertyHolder.getSource());
                if (propertyHolder.getParamTimestamp() <= latestTimestamp) continue;
                latestTimestamp = propertyHolder.getParamTimestamp();
            }
        }
        mergedHolder = new PropertyHolder(mergedMap, latestTimestamp);
        PropertyHolder existing = this.cachedMergedProperty.putIfAbsent(locale, mergedHolder);
        if (existing != null) {
            mergedHolder = existing;
        }
        return mergedHolder;
    }

    public void clearCache() {
        this.logger.debug((Object)"Clearing entire resource bundle cache");
        this.cachedProperty.clear();
        this.cachedMergedProperty.clear();
    }

    public void clearCacheIncludingAncestors() {
        this.clearCache();
        MessageSource parentMessageSource = this.getParentMessageSource();
        if (parentMessageSource instanceof ReloadablePropertiesMessageSource) {
            ((ReloadablePropertiesMessageSource)parentMessageSource).clearCacheIncludingAncestors();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ": basenames=" + this.getBasenameSet();
    }

    protected class PropertyHolder {
        @Nullable
        private final Map<String, String> source;
        private final long paramTimestamp;
        private volatile long refreshTimestamp = -2L;
        private final ReentrantLock refreshLock = new ReentrantLock();
        private final ConcurrentMap<String, Map<Locale, MessageFormat>> cachedMessageFormats = new ConcurrentHashMap<String, Map<Locale, MessageFormat>>();

        public PropertyHolder() {
            this.source = null;
            this.paramTimestamp = -1L;
        }

        public PropertyHolder(Map<String, String> source, long paramTimestamp) {
            this.source = source;
            this.paramTimestamp = paramTimestamp;
        }

        @Nullable
        public MessageFormat getMessageFormat(String code, Locale locale) {
            MessageFormat result;
            if (this.source == null) {
                return null;
            }
            Map<Locale, MessageFormat> localeMap = (ConcurrentHashMap<Locale, MessageFormat>)this.cachedMessageFormats.get(code);
            if (localeMap != null && (result = (MessageFormat)localeMap.get(locale)) != null) {
                return result;
            }
            String msg = this.source.get(code);
            if (msg != null) {
                Map existing;
                if (localeMap == null && (existing = (Map)this.cachedMessageFormats.putIfAbsent(code, localeMap = new ConcurrentHashMap<Locale, MessageFormat>())) != null) {
                    localeMap = existing;
                }
                MessageFormat result2 = ReloadablePropertiesMessageSource.this.createMessageFormat(msg, locale);
                localeMap.put(locale, result2);
                return result2;
            }
            return null;
        }

        @Nullable
        public String getMessage(String code) {
            if (this.source == null) {
                return null;
            }
            return this.source.get(code);
        }

        public void setRefreshTimestamp(long refreshTimestamp) {
            this.refreshTimestamp = refreshTimestamp;
        }

        public long getRefreshTimestamp() {
            return this.refreshTimestamp;
        }

        @Nullable
        public Map<String, String> getSource() {
            return this.source;
        }

        public long getParamTimestamp() {
            return this.paramTimestamp;
        }
    }

    private static class Param {
        private final String key;
        private final String locale;

        Param(String key, String locale) {
            this.key = key;
            this.locale = locale;
        }

        public String getKey() {
            return this.key;
        }

        public String getLocale() {
            return this.locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Param param = (Param)o;
            return Objects.equals(this.key, param.key) && Objects.equals(this.locale, param.locale);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.locale);
        }

        public String toString() {
            return "Param{key='" + this.key + '\'' + ", locale='" + this.locale + '\'' + '}';
        }
    }
}

