/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.session;

import com.cntaiping.ec.cloud.common.channel.http.processor.ContextProcessor;
import com.cntaiping.ec.cloud.common.core.Context;
import com.cntaiping.ec.cloud.common.core.ContextUtils;
import com.cntaiping.ec.cloud.common.session.SessionStorageBuilder;
import com.cntaiping.ec.cloud.common.session.SessionStoreContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SessionStoreContextHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionStoreContextHandlerInterceptor.class);
    private ContextProcessor contextProcessor;
    private SessionStorageBuilder sessionStorageBuilder;

    public SessionStoreContextHandlerInterceptor(SessionStorageBuilder sessionStorageBuilder, ContextProcessor contextProcessor) {
        this.sessionStorageBuilder = sessionStorageBuilder;
        this.contextProcessor = contextProcessor;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        LOGGER.trace("====>executing SessionStoreContextHandlerInterceptor#preHandle");
        SessionStoreContext context = new SessionStoreContext();
        context.setAttribute("x-channel-type", "http");
        context.setLocale(request.getLocale());
        context.setSessionStorageBuilder(this.sessionStorageBuilder);
        if (this.contextProcessor != null) {
            this.contextProcessor.resolveAttribute(context, request);
        }
        ContextUtils.set(context);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) throws Exception {
        LOGGER.trace("====>executing SessionStoreContextHandlerInterceptor#postHandle");
        Context context = ContextUtils.get();
        if (this.contextProcessor != null) {
            this.contextProcessor.postAttributes(context, request, response);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
        LOGGER.trace("====>executing SessionStoreContextHandlerInterceptor#afterCompletion");
        ContextUtils.remove();
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        LOGGER.trace("====>executing SessionStoreContextHandlerInterceptor#afterConcurrentHandlingStarted");
        ContextUtils.remove();
    }

    public ContextProcessor getContextProcessor() {
        return this.contextProcessor;
    }

    public void setContextProcessor(ContextProcessor contextProcessor) {
        this.contextProcessor = contextProcessor;
    }

    public SessionStorageBuilder getSessionStorageBuilder() {
        return this.sessionStorageBuilder;
    }

    public void setSessionStorageBuilder(SessionStorageBuilder sessionStorageBuilder) {
        this.sessionStorageBuilder = sessionStorageBuilder;
    }
}

