/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.session.http;

import com.cntaiping.ec.cloud.common.core.User;
import com.cntaiping.ec.cloud.common.core.UserEx;
import com.cntaiping.ec.cloud.common.exception.TPSCBPError;
import com.cntaiping.ec.cloud.common.session.SessionStorage;
import com.cntaiping.ec.cloud.common.session.http.HttpSessionUser;
import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.util.Assert;

public class HttpSessionStorage
implements SessionStorage {
    private String sessionId;
    private final Duration timeout;
    private final Set<String> attributes;
    private final Set<String> userAttributes;
    private final String prefix;
    private HttpSessionUser user;
    private boolean isNew;
    private final transient HttpServletRequest httpServletRequest;
    private transient HttpSession httpSession;

    public HttpSessionStorage(HttpServletRequest httpServletRequest, String prefix, Set<String> attributes, Duration timeout, String sessionId) {
        HttpSession session;
        Assert.notNull((Object)httpServletRequest, (String)"HttpServletRequest must not be null.");
        Assert.hasText((String)prefix, (String)"Prefix must not be empty.");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null.");
        this.httpServletRequest = httpServletRequest;
        this.timeout = timeout;
        this.prefix = prefix;
        this.sessionId = sessionId;
        this.user = null;
        this.isNew = true;
        this.attributes = new LinkedHashSet<String>();
        this.userAttributes = new LinkedHashSet<String>();
        if (attributes != null) {
            for (String attr : attributes) {
                if (attr.startsWith(prefix)) {
                    this.userAttributes.add(attr);
                    continue;
                }
                this.attributes.add(attr);
            }
        }
        if ((session = httpServletRequest.getSession(false)) != null && session.getId().equals(sessionId)) {
            this.isNew = false;
            this.httpSession = session;
        } else if (session == null) {
            this.httpSession = httpServletRequest.getSession(true);
            this.sessionId = this.httpSession.getId();
        } else {
            this.httpSession = session;
            this.sessionId = this.httpSession.getId();
        }
        this.httpSession.setMaxInactiveInterval((int)timeout.getSeconds());
    }

    public HttpSessionStorage(HttpServletRequest httpServletRequest, String prefix, Set<String> attributes, String sessionId) {
        this(httpServletRequest, prefix, attributes, Duration.ofMillis(30L), sessionId);
    }

    protected HttpSession httpSession() {
        if (this.httpSession == null) {
            this.httpSession = this.httpServletRequest.getSession(true);
            this.sessionId = this.httpSession.getId();
            this.httpSession.setMaxInactiveInterval((int)this.timeout.getSeconds());
        }
        return this.httpSession;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setUserId(String userId) {
        UserEx userEx = (UserEx)this.getUser();
        userEx.setUserId(userId);
    }

    @Override
    public Long getCreateTime() {
        return this.httpSession.getCreationTime();
    }

    @Override
    public Long getLastAccess() {
        return this.httpSession.getLastAccessedTime();
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public String getUserId() {
        if (this.user == null) {
            return this.isNew ? null : (String)this.httpSession.getAttribute("userId");
        }
        return this.user.getUserId();
    }

    @Override
    public <T> T getSessionAttribute(String name) {
        return (T)(this.attributes.contains(name) && this.httpSession != null ? this.httpSession.getAttribute(name) : null);
    }

    @Override
    public Map<String, Object> getSessionAttributes() {
        HashMap<String, Object> sessionAttributes = new HashMap<String, Object>();
        if (!this.attributes.isEmpty() && this.httpSession != null) {
            for (String key : this.attributes) {
                sessionAttributes.put(key, this.httpSession.getAttribute(key));
            }
        }
        return sessionAttributes;
    }

    @Override
    public void setSessionAttribute(String name, Serializable value) {
        if (this.attributes.contains(name)) {
            this.httpSession().setAttribute(name, (Object)value);
        }
    }

    @Override
    public <T extends User> T getUser() {
        if (this.user == null) {
            this.user = new HttpSessionUser(this.userAttributes, this.prefix, this.httpSession());
        }
        return (T)this.user;
    }

    @Override
    public void updateUser(User user) {
        if (this.user != user) {
            throw TPSCBPError.CURRENT_USER_NOT_MATCH.getInfo().initialize();
        }
        if (this.user != null) {
            this.user.update();
        }
    }
}

