/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.session.http;

import com.cntaiping.ec.cloud.common.session.SessionStorage;
import com.cntaiping.ec.cloud.common.session.SessionStorageBuilder;
import com.cntaiping.ec.cloud.common.session.http.HttpSessionStorage;
import java.time.Duration;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpSessionStorageBuilder
implements SessionStorageBuilder {
    private final Set<String> sessionFields;
    private final Duration timeout;
    private final String prefix;

    public HttpSessionStorageBuilder(Set<String> sessionFields, Duration timeout, String prefix) {
        Assert.notNull(sessionFields, (String)"SessionFields must not be null.");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null.");
        Assert.hasText((String)prefix, (String)"Prefix must not be empty.");
        this.sessionFields = sessionFields;
        this.timeout = timeout;
        this.prefix = prefix;
    }

    public HttpSessionStorageBuilder(Set<String> sessionFields, String prefix) {
        this(sessionFields, DEFAULT_TIMEOUT, prefix);
    }

    public HttpSessionStorageBuilder(Set<String> sessionFields) {
        this(sessionFields, DEFAULT_TIMEOUT, "user.");
    }

    @Override
    public SessionStorage build(String sessionId) {
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        return new HttpSessionStorage(httpServletRequest, this.prefix, this.sessionFields, this.timeout, sessionId);
    }

    @Override
    public boolean exists(String sessionId) {
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        HttpSession session = httpServletRequest.getSession(false);
        return session != null && session.getId().equals(sessionId);
    }
}

