/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.session.redis;

import com.cntaiping.ec.cloud.common.core.User;
import com.cntaiping.ec.cloud.common.core.UserEx;
import com.cntaiping.ec.cloud.common.exception.TPSCBPError;
import com.cntaiping.ec.cloud.common.session.SessionStorage;
import com.cntaiping.ec.cloud.common.session.redis.RedisUser;
import com.cntaiping.ec.cloud.common.utils.id.UUID62;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RedisSessionStorage
implements SessionStorage {
    public static final String CREATE_TIME = "createTime";
    public static final String LAST_ACCESS = "lastAccess";
    private String sessionId;
    private Long createTime;
    private Long lastAccess;
    private final Duration timeout;
    private final Set<String> attributes;
    private final Set<String> userAttributes;
    private final String prefix;
    private RedisUser user;
    private boolean isNew;
    private final transient RedisTemplate<String, Object> redisTemplate;
    private transient BoundHashOperations<String, String, Object> ops;

    public RedisSessionStorage(RedisTemplate<String, Object> redisTemplate, String prefix, Set<String> attributes, Duration timeout, String sessionId) {
        Assert.notNull(redisTemplate, (String)"RedisTemplate must not be null.");
        Assert.hasText((String)prefix, (String)"Prefix must not be empty.");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null.");
        this.redisTemplate = redisTemplate;
        this.prefix = prefix;
        this.timeout = timeout;
        this.sessionId = sessionId;
        this.isNew = true;
        this.user = null;
        this.attributes = new LinkedHashSet<String>();
        this.userAttributes = new LinkedHashSet<String>();
        this.attributes.add(CREATE_TIME);
        this.attributes.add(LAST_ACCESS);
        if (attributes != null) {
            for (String attr : attributes) {
                if (attr.startsWith(prefix)) {
                    this.userAttributes.add(attr);
                    continue;
                }
                this.attributes.add(attr);
            }
        }
        if (StringUtils.hasText((String)sessionId) && redisTemplate.hasKey((Object)this.sessionId).booleanValue()) {
            this.isNew = false;
            this.ops = redisTemplate.boundHashOps((Object)this.sessionId);
            List values = this.ops.multiGet(Arrays.asList(CREATE_TIME, LAST_ACCESS));
            this.createTime = (Long)values.get(0);
            this.lastAccess = (Long)values.get(1);
            this.ops.put((Object)LAST_ACCESS, (Object)System.currentTimeMillis());
            this.ops.expire(this.timeout);
        } else if (!StringUtils.hasText((String)sessionId)) {
            this.sessionId = UUID62.randomUUID62();
        }
    }

    public RedisSessionStorage(RedisTemplate<String, Object> redisTemplate, String prefix, Set<String> attributes, String sessionId) {
        this(redisTemplate, prefix, attributes, Duration.ofMillis(30L), sessionId);
    }

    protected BoundHashOperations<String, String, Object> ops() {
        if (this.ops == null) {
            this.ops = this.redisTemplate.boundHashOps((Object)this.sessionId);
            this.createTime = this.lastAccess = Long.valueOf(System.currentTimeMillis());
            this.ops.put((Object)CREATE_TIME, (Object)this.createTime);
            this.ops.put((Object)LAST_ACCESS, (Object)this.lastAccess);
            this.ops.expire(this.timeout);
        }
        return this.ops;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setUserId(String userId) {
        UserEx userEx = (UserEx)this.getUser();
        userEx.setUserId(userId);
    }

    @Override
    public Long getCreateTime() {
        return this.createTime;
    }

    @Override
    public Long getLastAccess() {
        return this.lastAccess;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public String getUserId() {
        if (this.user == null) {
            return this.isNew ? null : (String)this.ops.get((Object)"userId");
        }
        return this.user.getUserId();
    }

    @Override
    public <T> T getSessionAttribute(String name) {
        return (T)(this.attributes.contains(name) && this.ops != null ? this.ops.get((Object)name) : null);
    }

    @Override
    public Map<String, Object> getSessionAttributes() {
        HashMap<String, Object> sessionAttributes = new HashMap<String, Object>();
        if (!this.attributes.isEmpty() && this.ops != null) {
            List values = this.ops.multiGet(this.attributes);
            Iterator<String> keyIterator = this.attributes.iterator();
            Iterator valueIterator = values.iterator();
            while (keyIterator.hasNext()) {
                String key = keyIterator.next();
                sessionAttributes.put(key, valueIterator.next());
            }
        }
        return sessionAttributes;
    }

    @Override
    public void setSessionAttribute(String name, Serializable value) {
        if (this.attributes.contains(name)) {
            this.ops().put((Object)name, (Object)value);
        }
    }

    @Override
    public <T extends User> T getUser() {
        if (this.user == null) {
            this.user = new RedisUser(this.userAttributes, this.prefix, this.ops());
        }
        return (T)this.user;
    }

    @Override
    public void updateUser(User user) {
        if (this.user != user) {
            throw TPSCBPError.CURRENT_USER_NOT_MATCH.getInfo().initialize();
        }
        if (this.user != null) {
            this.user.update();
        }
    }
}

