/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.session.redis;

import com.cntaiping.ec.cloud.common.session.SessionStorage;
import com.cntaiping.ec.cloud.common.session.SessionStorageBuilder;
import com.cntaiping.ec.cloud.common.session.redis.RedisSessionStorage;
import java.time.Duration;
import java.util.Set;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class RedisSessionStorageBuilder
implements SessionStorageBuilder {
    private final RedisTemplate<String, Object> redisTemplate;
    private final Set<String> sessionFields;
    private final Duration timeout;
    private final String prefix;

    public RedisSessionStorageBuilder(RedisTemplate<String, Object> redisTemplate, Set<String> sessionFields, Duration timeout, String prefix) {
        Assert.notNull(redisTemplate, (String)"RedisTemplate must not be null.");
        Assert.notNull(sessionFields, (String)"SessionFields must not be null.");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null.");
        Assert.hasText((String)prefix, (String)"Prefix must not be empty.");
        this.redisTemplate = redisTemplate;
        this.sessionFields = sessionFields;
        this.timeout = timeout;
        this.prefix = prefix;
    }

    public RedisSessionStorageBuilder(RedisTemplate<String, Object> redisTemplate, Set<String> sessionFields, String prefix) {
        this(redisTemplate, sessionFields, DEFAULT_TIMEOUT, prefix);
    }

    public RedisSessionStorageBuilder(RedisTemplate<String, Object> redisTemplate, Set<String> sessionFields) {
        this(redisTemplate, sessionFields, DEFAULT_TIMEOUT, "user.");
    }

    @Override
    public SessionStorage build(String sessionId) {
        return new RedisSessionStorage(this.redisTemplate, this.prefix, this.sessionFields, this.timeout, sessionId);
    }

    @Override
    public boolean exists(String sessionId) {
        return this.redisTemplate.hasKey((Object)sessionId);
    }
}

