/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.session.redis;

import com.cntaiping.ec.cloud.common.core.UserEx;
import com.cntaiping.ec.cloud.common.utils.json.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.util.Assert;

public class RedisUser
implements UserEx,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> baseData;
    private String userId;
    private Locale locale;
    private boolean anyBaseDataChanged = false;
    private final Collection<String> attributeNames;
    private final String prefix;
    private final BoundHashOperations<String, String, Object> ops;

    public RedisUser(Collection<String> attributeNames, String prefix, BoundHashOperations<String, String, Object> ops) {
        Assert.hasText((String)prefix, (String)"Prefix must not empty.");
        Assert.notNull(ops, (String)"BoundHashOperations must not be null.");
        this.attributeNames = attributeNames == null ? Collections.emptySet() : attributeNames;
        this.prefix = prefix;
        this.ops = ops;
        this.userId = (String)ops.get((Object)"userId");
        String serializedBaseData = null;
        if (this.userId != null) {
            serializedBaseData = (String)ops.get((Object)(this.prefix + this.userId));
        }
        this.baseData = serializedBaseData != null ? JsonUtils.readValue(serializedBaseData, new TypeReference<Map<String, Object>>(){}) : new HashMap<String, Object>();
    }

    @Override
    public boolean isLogined() {
        return this.baseData != null && "true".equals(this.baseData.get("logined"));
    }

    @Override
    public String getState() {
        return (String)this.baseData.get("state");
    }

    @Override
    public String getUniqueId() {
        return (String)this.baseData.get("uniqueId");
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getCifId() {
        return (String)this.baseData.get("cifId");
    }

    @Override
    public String getUUID() {
        return (String)this.baseData.get("uuid");
    }

    @Override
    public String getName() {
        return (String)this.baseData.get("name");
    }

    @Override
    public String[] getRoles() {
        List roles = (List)this.baseData.get("roles");
        if (roles != null && !roles.isEmpty()) {
            String[] ret = new String[roles.size()];
            return roles.toArray(ret);
        }
        return new String[0];
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            List parts = (List)this.baseData.get("locale");
            if (parts != null && parts.size() == 3) {
                this.locale = new Locale((String)parts.get(0), (String)parts.get(1), (String)parts.get(2));
                return this.locale;
            }
            return Locale.CHINA;
        }
        return this.locale;
    }

    @Override
    public <T> T getAttribute(String attributeName) {
        String key = this.prefix + attributeName;
        return (T)(this.attributeNames.contains(attributeName) ? this.ops.get((Object)key) : null);
    }

    @Override
    public Map<String, Object> getAttributes() {
        List values;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.attributeNames.isEmpty() && (values = this.ops.multiGet(this.attributeNames)) != null && !values.isEmpty()) {
            Iterator valueIterator = values.iterator();
            for (String key : this.attributeNames) {
                map.put(key, valueIterator.next());
            }
        }
        return map;
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) {
        String key = this.prefix + attributeName;
        if (this.attributeNames.contains(key)) {
            this.ops.put((Object)key, attributeValue);
        }
    }

    @Override
    public void setCifId(String cifId) {
        this.baseData.put("cifId", cifId);
        this.anyBaseDataChanged = true;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
        this.baseData.put("locale", Arrays.asList(locale.getLanguage(), locale.getCountry(), locale.getVariant()));
        this.anyBaseDataChanged = true;
    }

    @Override
    public void setName(String name) {
        this.baseData.put("name", name);
        this.anyBaseDataChanged = true;
    }

    @Override
    public void setRoles(String ... roles) {
        this.baseData.put("roles", Arrays.asList(roles));
        this.anyBaseDataChanged = true;
    }

    @Override
    public void setUniqueId(String uniqueId) {
        this.baseData.put("uniqueId", uniqueId);
        this.anyBaseDataChanged = true;
    }

    @Override
    public void setUserId(String userId) {
        this.ops.put((Object)"userId", (Object)userId);
        this.anyBaseDataChanged = true;
        this.userChanged(userId);
    }

    @Override
    public void setUUID(String uuid) {
        this.baseData.put("uuid", uuid);
        this.anyBaseDataChanged = true;
    }

    @Override
    public void setState(String state) {
        this.baseData.put("state", state);
        this.anyBaseDataChanged = true;
    }

    @Override
    public void setLogined(boolean logined) {
        if (!logined) {
            this.userChanged(null);
        }
        this.baseData.put("logined", String.valueOf(logined));
        this.anyBaseDataChanged = true;
    }

    protected void userChanged(String newUserId) {
        if (this.userId != null && !this.userId.equals(newUserId)) {
            this.baseData = new HashMap<String, Object>();
            this.ops.delete(new Object[]{this.prefix + this.userId});
            if (!this.attributeNames.isEmpty()) {
                this.ops.delete(this.attributeNames.toArray());
            }
        }
        this.userId = newUserId;
    }

    public void update() {
        if (this.anyBaseDataChanged) {
            String key = this.prefix + this.userId;
            if (this.baseData != null && !this.baseData.isEmpty()) {
                this.ops.put((Object)key, (Object)JsonUtils.writeValueAsString(this.baseData));
            } else {
                this.ops.delete(new Object[]{key});
            }
        }
    }
}

