/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.thirdaccess;

import com.cntaiping.ec.cloud.common.core.Context;
import com.cntaiping.ec.cloud.common.core.ContextUtils;
import com.cntaiping.ec.cloud.common.exception.BaseRuntimeException;
import com.cntaiping.ec.cloud.common.exception.ExceptionUtil;
import com.cntaiping.ec.cloud.common.exception.TPSCBPError;
import com.cntaiping.ec.cloud.common.session.SessionIdUtils;
import com.cntaiping.ec.cloud.common.thirdaccess.ThirdAccessLogInfo;
import com.cntaiping.ec.cloud.common.thirdaccess.ThirdAccessLogProcessor;
import com.cntaiping.ec.cloud.common.utils.id.UUID62;
import com.cntaiping.ec.cloud.common.utils.trace.TraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSourceResolvable;

public class BaseThirdAccessLogProcessor<Log extends ThirdAccessLogInfo>
implements ThirdAccessLogProcessor<Log> {
    protected Logger logger = LoggerFactory.getLogger(BaseThirdAccessLogProcessor.class);

    @Override
    public Log newLog() {
        ThirdAccessLogInfo log = new ThirdAccessLogInfo();
        log.init();
        log.setLogNo(UUID62.randomUUID62());
        return (Log)log;
    }

    @Override
    public void save(Log logInfo) {
        this.logger.info("Save Log::{}", logInfo);
    }

    @Override
    public void before(Log logInfo, Object request) {
        ((ThirdAccessLogInfo)logInfo).setSuccess(true);
        this.logBaseInfo(logInfo);
    }

    private void logBaseInfo(Log logInfo) {
        Context context = ContextUtils.get();
        if (context == null) {
            return;
        }
        ((ThirdAccessLogInfo)logInfo).setEndpoint(context.getEndpoint());
        ((ThirdAccessLogInfo)logInfo).setSessionId(SessionIdUtils.get());
        ((ThirdAccessLogInfo)logInfo).setTraceNo(TraceUtils.get());
        this.logUser(logInfo, context);
    }

    @Override
    public void after(Log logInfo, Object response, Throwable th) {
        Context context = ContextUtils.get();
        if (context != null) {
            this.logUser(logInfo, context);
        }
        this.logError(logInfo, context, th);
    }

    protected void logUser(Log logInfo, Context context) {
        Object user = context.getUser();
        if (user != null) {
            ((ThirdAccessLogInfo)logInfo).setUserId(user.getUserId());
        }
    }

    protected void logError(Log logInfo, Context context, Throwable th) {
        th = ExceptionUtil.unwrapThrowable(th);
        if (((ThirdAccessLogInfo)logInfo).isSuccess() && th != null) {
            ((ThirdAccessLogInfo)logInfo).setSuccess(false);
            if (th instanceof BaseRuntimeException) {
                BaseRuntimeException bre = (BaseRuntimeException)th;
                ((ThirdAccessLogInfo)logInfo).setCode(bre.getCode());
                ((ThirdAccessLogInfo)logInfo).setMessage(bre.getMessage());
            } else if (th instanceof MessageSourceResolvable) {
                MessageSourceResolvable msr = (MessageSourceResolvable)th;
                String[] codes = msr.getCodes();
                if (codes != null) {
                    ((ThirdAccessLogInfo)logInfo).setCode(codes[0]);
                }
                ((ThirdAccessLogInfo)logInfo).setMessage(msr.getDefaultMessage());
            } else {
                ((ThirdAccessLogInfo)logInfo).setCode(TPSCBPError.UNKNOWN.getInfo().getCode());
                ((ThirdAccessLogInfo)logInfo).setMessage(th.getMessage());
            }
        }
    }
}

