/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.thirdaccess;

import com.cntaiping.ec.cloud.common.SystemProperties;
import com.cntaiping.ec.cloud.common.core.ContextUtils;
import com.cntaiping.ec.cloud.common.exception.TPSCBPError;
import com.cntaiping.ec.cloud.common.log.LogInfo;
import com.cntaiping.ec.cloud.common.log.LogUtils;
import com.cntaiping.ec.cloud.common.thirdaccess.ThirdAccessLogInfo;
import com.cntaiping.ec.cloud.common.thirdaccess.ThirdAccessLogProperties;
import com.cntaiping.ec.cloud.common.thirdaccess.ThirdAccessLogUtils;
import com.cntaiping.ec.cloud.common.thirdaccess.ThirdApiAccess;
import com.cntaiping.ec.cloud.common.thirdaccess.ThirdComponent;
import com.cntaiping.ec.cloud.common.utils.log.TrackUtils;
import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Aspect
@Order(value=0x7FFFFFF5)
public class ThirdAccessLogAspect
implements EnvironmentAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdAccessLogAspect.class);
    private static final Counter THIRD_ACCESS_COUNTER = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("third_call_counter")).labelNames(new String[]{"service", "instance", "apiName", "hostCode"})).help("Third Call Counter")).register();
    private static final Summary THIRD_ACCESS_SUMMARY = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("third_call_summary")).labelNames(new String[]{"service", "instance", "apiName", "hostCode"})).help("Third Call Consume Time")).register();
    private ThirdAccessLogProperties properties;
    private SystemProperties systemProperties;
    private Environment environment;

    public ThirdAccessLogAspect(ThirdAccessLogProperties properties, SystemProperties systemProperties) {
        this.properties = properties;
        this.systemProperties = systemProperties;
    }

    @Pointcut(value="@within(com.cntaiping.ec.cloud.common.thirdaccess.ThirdComponent)&& @annotation(com.cntaiping.ec.cloud.common.thirdaccess.ThirdApiAccess)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint joinPoint) {
        Object result = null;
        Throwable throwable = null;
        ThirdAccessLogInfo thirdAccessLogInfo = null;
        try {
            long startTime = System.currentTimeMillis();
            thirdAccessLogInfo = this.getThirdAccessLogInfo();
            ThirdAccessLogUtils.logProcessor().before(thirdAccessLogInfo, ContextUtils.get());
            this.fillThirdAccessLogInfo(thirdAccessLogInfo, joinPoint);
            LogInfo logInfo = LogUtils.current(false);
            if (logInfo != null) {
                logInfo.addHostCode(thirdAccessLogInfo.getRequestHostCode());
            }
            result = joinPoint.proceed();
            long consumeTime = System.currentTimeMillis() - startTime;
            thirdAccessLogInfo.setTiming(consumeTime);
            TrackUtils.track(LOGGER, (JoinPoint)joinPoint, result);
            if (consumeTime > 5000L) {
                LOGGER.error("Third api call::System:[{}], Address:[{}], ApiName:[{}], HostCode:[{}] Method:[{}] consume [{}] ms", new Object[]{thirdAccessLogInfo.getRequestSystem(), thirdAccessLogInfo.getRequestAddress(), thirdAccessLogInfo.getRequestApiName(), thirdAccessLogInfo.getRequestHostCode(), thirdAccessLogInfo.getMethod(), consumeTime});
            } else {
                LOGGER.info("Third api call::System:[{}], Address:[{}], ApiName:[{}], HostCode:[{}] Method:[{}] consume [{}] ms", new Object[]{thirdAccessLogInfo.getRequestSystem(), thirdAccessLogInfo.getRequestAddress(), thirdAccessLogInfo.getRequestApiName(), thirdAccessLogInfo.getRequestHostCode(), thirdAccessLogInfo.getMethod(), consumeTime});
            }
            if (this.properties.isEnablePrometheus()) {
                ((Counter.Child)THIRD_ACCESS_COUNTER.labels(new String[]{thirdAccessLogInfo.getService(), thirdAccessLogInfo.getInstance(), thirdAccessLogInfo.getRequestApiName(), thirdAccessLogInfo.getRequestHostCode()})).inc();
                ((Summary.Child)THIRD_ACCESS_SUMMARY.labels(new String[]{thirdAccessLogInfo.getService(), thirdAccessLogInfo.getInstance(), thirdAccessLogInfo.getRequestApiName(), thirdAccessLogInfo.getRequestHostCode()})).observe((double)consumeTime);
            }
            Object object = result;
            return object;
        }
        catch (Throwable th) {
            throwable = th;
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw TPSCBPError.UNKNOWN.getInfo().initialize(th);
        }
        finally {
            this.afterLog(thirdAccessLogInfo, throwable);
        }
    }

    private void fillThirdAccessLogInfo(ThirdAccessLogInfo thirdAccessLogInfo, ProceedingJoinPoint joinPoint) throws NoSuchMethodException {
        Class<?> targetClazz = joinPoint.getTarget().getClass();
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        Method targetMethod = targetClazz.getDeclaredMethod(signature.getName(), method.getParameterTypes());
        String simpleClassName = targetClazz.getSimpleName();
        String methodName = targetMethod.getName();
        ThirdComponent thirdComponent = targetClazz.getAnnotation(ThirdComponent.class);
        ThirdApiAccess thirdApiAccess = targetMethod.getAnnotation(ThirdApiAccess.class);
        String system = thirdComponent.desc();
        String address = thirdComponent.address();
        String apiName = thirdApiAccess.desc();
        String hostCode = thirdApiAccess.hostCode();
        String accessSystem = thirdApiAccess.system();
        String accessAddress = thirdApiAccess.address();
        if (StringUtils.hasText((String)accessSystem)) {
            system = accessSystem;
        }
        if (StringUtils.hasText((String)accessAddress)) {
            address = accessAddress;
        }
        system = this.environment.resolvePlaceholders(system);
        address = this.environment.resolvePlaceholders(address);
        apiName = this.environment.resolvePlaceholders(apiName);
        hostCode = this.environment.resolvePlaceholders(hostCode);
        LOGGER.debug("Third api call::System:[{}], Address:[{}], ApiName:[{}], HostCode:[{}] Method:[{}#{}] execute start...", new Object[]{system, address, apiName, hostCode, simpleClassName, methodName});
        thirdAccessLogInfo.setMethod(simpleClassName + "#" + methodName);
        thirdAccessLogInfo.setRequestSystem(system);
        thirdAccessLogInfo.setRequestAddress(address);
        thirdAccessLogInfo.setRequestApiName(apiName);
        thirdAccessLogInfo.setRequestHostCode(hostCode);
    }

    private ThirdAccessLogInfo getThirdAccessLogInfo() {
        ThirdAccessLogInfo thirdAccessLogInfo = ThirdAccessLogUtils.current(true);
        thirdAccessLogInfo.setSystemCode(this.systemProperties.getSystemCode());
        thirdAccessLogInfo.setService(this.systemProperties.getSystemName());
        thirdAccessLogInfo.setInstance(this.systemProperties.getHostName());
        return thirdAccessLogInfo;
    }

    private void afterLog(ThirdAccessLogInfo log, Throwable th) {
        try {
            ThirdAccessLogUtils.logProcessor().after(log, ContextUtils.get(), th);
            ThirdAccessLogUtils.save();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save log", (Throwable)e);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

