/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.thirdaccess;

import com.cntaiping.ec.cloud.common.thirdaccess.ThirdAccessLogInfo;
import com.cntaiping.ec.cloud.common.thirdaccess.ThirdAccessLogProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdAccessLogUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdAccessLogUtils.class);
    private static final ThreadLocal<ThirdAccessLogInfo> LOG_INFO_THREAD_LOCAL = new InheritableThreadLocal<ThirdAccessLogInfo>();
    private static ThirdAccessLogProcessor<ThirdAccessLogInfo> LOG_PROCESSOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogProcessor(ThirdAccessLogProcessor<ThirdAccessLogInfo> logProcessor) {
        ThirdAccessLogUtils thirdAccessLogUtils = this;
        synchronized (thirdAccessLogUtils) {
            LOG_PROCESSOR = logProcessor;
        }
    }

    public static ThirdAccessLogInfo current(boolean createNew) {
        ThirdAccessLogInfo log = LOG_INFO_THREAD_LOCAL.get();
        if (log == null && createNew) {
            log = LOG_PROCESSOR.newLog();
            LOG_INFO_THREAD_LOCAL.set(log);
        }
        return log;
    }

    public static ThirdAccessLogProcessor<ThirdAccessLogInfo> logProcessor() {
        return LOG_PROCESSOR;
    }

    public static void clear() {
        LOG_INFO_THREAD_LOCAL.remove();
    }

    public static void save() {
        ThirdAccessLogInfo log = LOG_INFO_THREAD_LOCAL.get();
        try {
            if (log != null && !log.isRecord() && LOG_PROCESSOR != null) {
                log.record();
                LOG_PROCESSOR.save(log);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save log", (Throwable)e);
        }
        finally {
            ThirdAccessLogUtils.clear();
        }
    }
}

