/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.thirdaccess.processor;

import com.cntaiping.ec.cloud.common.thirdaccess.BaseThirdAccessLogProcessor;
import com.cntaiping.ec.cloud.common.thirdaccess.ThirdAccessLogInfo;
import com.cntaiping.ec.cloud.common.thirdaccess.ThirdAccessLogProperties;
import com.cntaiping.ec.cloud.common.utils.json.JsonUtils;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcLogProcessor
extends BaseThirdAccessLogProcessor<ThirdAccessLogInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcLogProcessor.class);
    private final JdbcTemplate jdbcTemplate;
    private final ThirdAccessLogProperties logProperties;

    public JdbcLogProcessor(DataSource dataSource, ThirdAccessLogProperties logProperties) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.logProperties = logProperties;
    }

    @Override
    public void save(ThirdAccessLogInfo logInfo) {
        try {
            this.jdbcTemplate.update(this.logProperties.getJdbc().getTable().getInsertStatement(), new Object[]{this.subString(logInfo.getLogNo(), 120), this.subString(logInfo.getTraceNo(), 360), this.subString(logInfo.getSessionId(), 120), this.subString(logInfo.getUserId(), 120), this.subString(logInfo.getSystemCode(), 8), this.subString(logInfo.getService(), 36), this.subString(logInfo.getInstance(), 120), this.subString(logInfo.getEndpoint(), 360), this.subString(logInfo.getMethod(), 360), this.subString(logInfo.getRequestSystem(), 120), this.subString(logInfo.getRequestAddress(), 360), this.subString(logInfo.getRequestApiName(), 120), this.subString(logInfo.getRequestHostCode(), 120), logInfo.getTiming(), logInfo.isSuccess(), this.subString(logInfo.getCode(), 36), this.subString(logInfo.getMessage(), 1200), JsonUtils.writeValueAsString(logInfo.getAdditionInfo()), logInfo.getCreateTime(), logInfo.getCreateTime()}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, -5, -6, 12, 12, 12, 91, 91});
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save log.", (Throwable)e);
        }
    }

    private String subString(String str, int len) {
        if (str == null) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }
}

