/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.thirdaccess.processor;

import com.cntaiping.ec.cloud.common.thirdaccess.BaseThirdAccessLogProcessor;
import com.cntaiping.ec.cloud.common.thirdaccess.ThirdAccessLogInfo;
import com.cntaiping.ec.cloud.common.thirdaccess.ThirdAccessLogProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaProducerException;
import org.springframework.kafka.core.KafkaSendCallback;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class KafkaLogProcessor
extends BaseThirdAccessLogProcessor<ThirdAccessLogInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"KafkaLogProcessor");
    private final KafkaTemplate<String, Object> kafkaTemplate;
    private final ThirdAccessLogProperties logProperties;

    public KafkaLogProcessor(KafkaTemplate<String, Object> kafkaTemplate, ThirdAccessLogProperties logProperties) {
        this.kafkaTemplate = kafkaTemplate;
        this.logProperties = logProperties;
    }

    @Override
    public void save(ThirdAccessLogInfo logInfo) {
        ListenableFuture future = this.kafkaTemplate.send(this.logProperties.getKafka().getTopic(), (Object)logInfo.getLogNo(), (Object)logInfo);
        future.addCallback((ListenableFutureCallback)new KafkaSendCallback<String, Object>(){

            public void onSuccess(SendResult<String, Object> sendResult) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Send message [{}] successfully.", sendResult);
                }
            }

            public void onFailure(KafkaProducerException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Send message [{}] failure.", (Object)e.getFailedProducerRecord());
                }
            }
        });
    }
}

