/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.concurrent;

import java.time.Duration;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolMonitor
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolMonitor.class);
    private final ThreadPoolExecutor executor;
    private final Duration delay;
    private volatile boolean running = true;

    public ThreadPoolMonitor(ThreadPoolExecutor executor, Duration delay) {
        this.executor = executor;
        this.delay = delay;
    }

    public void shutdown() {
        this.running = false;
    }

    @Override
    public void run() {
        while (this.running) {
            if (this.executor.isTerminated()) {
                LOGGER.info("[monitor] [{}]\u4efb\u52a1\u6267\u884c\u5b8c\u6210", (Object)this.executor);
                break;
            }
            LOGGER.info("[monitor] [{}] \u6c60\u5927\u5c0f: {}, \u6838\u5fc3\u6570: {}, \u6d3b\u8dc3\u6570: {}, \u5b8c\u6210\u6570: {}, \u4efb\u52a1\u6570: {}, \u7ebf\u7a0b\u662f\u5426\u7ed3\u675f: {}, \u4efb\u52a1\u662f\u5426\u7ed3\u675f: {}", new Object[]{this.executor, this.executor.getPoolSize(), this.executor.getCorePoolSize(), this.executor.getActiveCount(), this.executor.getCompletedTaskCount(), this.executor.getTaskCount(), this.executor.isShutdown(), this.executor.isTerminated()});
            try {
                Thread.sleep(this.delay.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

