/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.condition;

import com.cntaiping.ec.cloud.common.utils.condition.AbstractBeanCondition;
import com.cntaiping.ec.cloud.common.utils.condition.AbstractCollectionCondition;
import com.cntaiping.ec.cloud.common.utils.condition.AbstractCollectionElementCondition;
import com.cntaiping.ec.cloud.common.utils.condition.AbstractCompoundCondition;
import com.cntaiping.ec.cloud.common.utils.condition.AbstractCondition;
import com.cntaiping.ec.cloud.common.utils.condition.AbstractDateCondition;
import com.cntaiping.ec.cloud.common.utils.condition.AbstractMapCondition;
import com.cntaiping.ec.cloud.common.utils.condition.AbstractRangeCondition;
import com.cntaiping.ec.cloud.common.utils.condition.ComparableComparator;
import com.cntaiping.ec.cloud.common.utils.condition.Condition;
import com.cntaiping.ec.cloud.common.utils.condition.ProxyCondition;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.springframework.beans.BeanWrapper;
import org.springframework.util.Assert;

public class Conditions {
    private static final String EMAIL_REGEXP = "^(([A-Za-z0-9]+_+)|([A-Za-z0-9]+\\-+)|([A-Za-z0-9]+\\.+)|([A-Za-z0-9]+\\++))*[A-Za-z0-9]+@((\\w+\\-+)|(\\w+\\.))*\\w{1,63}\\.[a-zA-Z]{2,6}$";

    public static Condition TRUE() {
        return new TrueCondition();
    }

    public static Condition FALSE() {
        return new FalseCondition();
    }

    public static Condition isTrue() {
        return new IsTrueCondition();
    }

    public static Condition isFalse() {
        return Conditions.not(Conditions.isTrue());
    }

    public static Condition isNull() {
        return new IsNullCondition();
    }

    public static Condition notNull() {
        return Conditions.not(new IsNullCondition());
    }

    public static Condition not(Condition condition) {
        return new NotCondition(condition);
    }

    public static Condition and(Condition c1, Condition c2) {
        return Conditions.and(new Condition[]{c1, c2});
    }

    public static Condition and(Condition[] conditions) {
        return new AndCondition(conditions);
    }

    public static Condition and(Collection<Condition> conditions) {
        return new AndCondition(conditions);
    }

    public static Condition or(Condition c1, Condition c2) {
        return Conditions.or(new Condition[]{c1, c2});
    }

    public static Condition or(Condition[] conditions) {
        return new OrCondition(conditions);
    }

    public static Condition or(Collection<Condition> conditions) {
        return new OrCondition(conditions);
    }

    public static Condition EQ(Object obj) {
        return new EqualsCondition(obj);
    }

    public static Condition same(Object obj) {
        return new SameCondition(obj);
    }

    public static Condition typeof(Class<?> clazz) {
        return new TypeofCondition(clazz);
    }

    public static Condition isArray() {
        return new IsArrayCondition();
    }

    public static Condition isArray(Class<?> clazz) {
        return new IsTypeArrayCondition(clazz);
    }

    public static Condition in(Object[] values) {
        return new InCondition(values);
    }

    public static Condition between(Date start, Date end, boolean earlierIncluded, boolean laterIncluded) {
        return new BetweenDateCondition(start, end, earlierIncluded, laterIncluded);
    }

    public static Condition between(Calendar start, Calendar end, boolean earlierIncluded, boolean laterIncluded) {
        return new BetweenDateCondition(start, end, earlierIncluded, laterIncluded);
    }

    public static Condition before(Date end) {
        return new BetweenDateCondition(null, end, true, false);
    }

    public static Condition before(Calendar end) {
        return new BetweenDateCondition(null, end, true, false);
    }

    public static Condition after(Date start) {
        return new BetweenDateCondition(start, null, false, true);
    }

    public static Condition after(Calendar start) {
        return new BetweenDateCondition(start, null, false, true);
    }

    public static Condition isBlank() {
        return new IsBlankCondition();
    }

    public static Condition notBlank() {
        return Conditions.not(Conditions.isBlank());
    }

    public static Condition isEmail() {
        return new RFC822Condition().and(Conditions.regex(EMAIL_REGEXP));
    }

    public static Condition equalsIgnoreCase(String text) {
        return new EqualsIgnoreCaseCondition(text);
    }

    public static Condition contains(String text) {
        return new ContainsCondition(text);
    }

    public static Condition startsWith(String text) {
        return new StartsWithCondition(text);
    }

    public static Condition endsWith(String text) {
        return new EndsWithCondition(text);
    }

    public static Condition regex(String regex) {
        return new RegExpCondition(regex);
    }

    public static Condition minLength(int minLength) {
        return new LengthRangeCondition(minLength, Integer.MAX_VALUE);
    }

    public static Condition maxLength(int maxLength) {
        return new LengthRangeCondition(0, maxLength);
    }

    public static Condition lengthRange(int minLength, int maxLength) {
        return new LengthRangeCondition(minLength, maxLength);
    }

    public static Condition isEmpty() {
        return new IsEmptyCollectionCondition();
    }

    public static Condition notEmpty() {
        return Conditions.not(Conditions.isEmpty());
    }

    public static Condition minSize(int minSize) {
        return new SizeRangeCollectionCondition(minSize, Integer.MAX_VALUE);
    }

    public static Condition maxSize(int maxSize) {
        return new SizeRangeCollectionCondition(Integer.MIN_VALUE, maxSize);
    }

    public static Condition sizeRange(int minSize, int maxSize) {
        return new SizeRangeCollectionCondition(minSize, maxSize);
    }

    public static Condition all(Condition elementCondition) {
        return new AllCollectionCondition(elementCondition);
    }

    public static Condition none(Condition elementCondition) {
        return new NoneCollectionCondition(elementCondition);
    }

    public static Condition any(Condition elementCondition) {
        return new AnyCollectionCondition(elementCondition);
    }

    public static Condition atLeast(Condition elementCondition, int count) {
        return new AtLeastCollectionCondition(elementCondition, count);
    }

    public static Condition atMost(Condition elementCondition, int count) {
        return new AtMostCollectionCondition(elementCondition, count);
    }

    public static Condition GT(Comparable<?> min) {
        return new RangeCondition(min, null, false, false);
    }

    public static Condition GE(Comparable<?> min) {
        return new RangeCondition(min, null, true, false);
    }

    public static Condition LT(Comparable<?> max) {
        return new RangeCondition(null, max, false, false);
    }

    public static Condition LE(Comparable<?> max) {
        return new RangeCondition(null, max, false, true);
    }

    public static Condition range(Comparable<?> min, Comparable<?> max, boolean minIncluded, boolean maxIncluded) {
        return new RangeCondition(min, max, minIncluded, maxIncluded);
    }

    public static Condition property(String propertyName, Condition condition) {
        return new BeanPropertyCondition(propertyName, condition);
    }

    public static Condition entry(String key, Condition entryCondition) {
        return new MapEntryCondition(key, entryCondition);
    }

    private static final class TrueCondition
    extends AbstractCondition {
        private TrueCondition() {
        }

        @Override
        protected boolean doCheck(Object obj) {
            return true;
        }
    }

    private static final class FalseCondition
    extends AbstractCondition {
        private FalseCondition() {
        }

        @Override
        protected boolean doCheck(Object obj) {
            return false;
        }
    }

    private static final class TypeofCondition
    extends AbstractCondition {
        private Class<?> clazz;

        public TypeofCondition(Class<?> clazz) {
            Assert.notNull(clazz, (String)"Class cannot be null");
            this.clazz = clazz;
        }

        @Override
        protected boolean doCheck(Object obj) {
            return this.clazz.isAssignableFrom(obj.getClass());
        }
    }

    private static final class IsTypeArrayCondition
    extends AbstractCondition {
        private Class<?> clazz;

        public IsTypeArrayCondition(Class<?> clazz) {
            Assert.notNull(clazz, (String)"Class cannot be null");
            this.clazz = clazz;
        }

        @Override
        protected boolean doCheck(Object object) {
            return object.getClass().isArray() && this.clazz.isAssignableFrom(object.getClass().getComponentType());
        }
    }

    private static final class IsArrayCondition
    extends AbstractCondition {
        private IsArrayCondition() {
        }

        @Override
        protected boolean doCheck(Object object) {
            return object.getClass().isArray();
        }
    }

    private static final class IsTrueCondition
    extends AbstractCondition {
        private IsTrueCondition() {
        }

        @Override
        protected boolean doCheck(Object object) {
            return (Boolean)object;
        }
    }

    private static final class IsNullCondition
    extends AbstractCondition {
        private IsNullCondition() {
        }

        @Override
        protected boolean doCheck(Object object) {
            return object == null;
        }
    }

    private static final class IsBlankCondition
    extends AbstractCondition {
        private IsBlankCondition() {
        }

        @Override
        protected boolean doCheck(Object text) {
            return ((String)text).length() == 0;
        }
    }

    private static final class IsEmptyCollectionCondition
    extends AbstractCollectionCondition {
        private IsEmptyCollectionCondition() {
        }

        @Override
        protected boolean checkArray(Object array) {
            return Array.getLength(array) == 0;
        }

        @Override
        protected boolean checkCollection(Collection<?> collection) {
            return collection.isEmpty();
        }
    }

    private static final class EndsWithCondition
    extends AbstractCondition {
        private String substring;

        public EndsWithCondition(String substring) {
            Assert.notNull((Object)substring, (String)"ends with string cannot be null");
            this.substring = substring;
        }

        @Override
        protected boolean doCheck(Object text) {
            return ((String)text).endsWith(this.substring);
        }
    }

    private static final class StartsWithCondition
    extends AbstractCondition {
        private String substring;

        public StartsWithCondition(String substring) {
            Assert.notNull((Object)substring, (String)"starts with string cannot be null");
            this.substring = substring;
        }

        @Override
        protected boolean doCheck(Object text) {
            return ((String)text).startsWith(this.substring);
        }
    }

    private static final class ContainsCondition
    extends AbstractCondition {
        private String substring;

        public ContainsCondition(String substring) {
            Assert.notNull((Object)substring, (String)"contains string cannot be null");
            this.substring = substring;
        }

        @Override
        protected boolean doCheck(Object text) {
            return ((String)text).contains(this.substring);
        }
    }

    private static final class EqualsIgnoreCaseCondition
    extends AbstractCondition {
        private String text;

        public EqualsIgnoreCaseCondition(String text) {
            Assert.notNull((Object)text, (String)"equals string cannot be null");
            this.text = text;
        }

        @Override
        protected boolean doCheck(Object text) {
            return this.text.equalsIgnoreCase((String)text);
        }
    }

    private static final class EqualsCondition
    extends AbstractCondition {
        private Object obj;

        public EqualsCondition(Object obj) {
            Assert.notNull((Object)obj, (String)"equals object cannot be null");
            this.obj = obj;
        }

        @Override
        protected boolean doCheck(Object obj) {
            return this.obj.equals(obj);
        }
    }

    private static final class LengthRangeCondition
    extends AbstractCondition {
        private int minLength;
        private int maxLength;

        public LengthRangeCondition(int minLength, int maxLength) {
            this.minLength = minLength;
            this.maxLength = maxLength;
        }

        @Override
        protected boolean doCheck(Object text) {
            int length = ((String)text).length();
            return length >= this.minLength && length <= this.maxLength;
        }
    }

    private static final class SizeRangeCollectionCondition
    extends AbstractCollectionCondition {
        private int minSize;
        private int maxSize;

        public SizeRangeCollectionCondition(int minSize, int maxSize) {
            this.minSize = minSize;
            this.maxSize = maxSize;
        }

        @Override
        protected boolean checkArray(Object array) {
            int length = Array.getLength(array);
            return length >= this.minSize && length <= this.maxSize;
        }

        @Override
        protected boolean checkCollection(Collection<?> collection) {
            int size = collection.size();
            return size >= this.minSize && size <= this.maxSize;
        }
    }

    private static final class RangeCondition
    extends AbstractRangeCondition {
        private Comparable<?> lowerBound;
        private Comparable<?> upperBound;
        private boolean lowerBoundIncluded;
        private boolean upperBoundIncluded;

        public RangeCondition(Comparable<?> lowerBound, Comparable<?> upperBound, boolean lowerBoundIncluded, boolean upperBoundIncluded) {
            super(new NumberAwareComparableComparator());
            Assert.isTrue((lowerBound != null || upperBound != null ? 1 : 0) != 0, (String)"Both Lower bound and Upper bound are null");
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.lowerBoundIncluded = lowerBoundIncluded;
            this.upperBoundIncluded = upperBoundIncluded;
        }

        @Override
        protected boolean checkRange(Comparable<?> value, Comparator<Comparable<?>> comparator) {
            if (this.lowerBound != null && (this.lowerBoundIncluded ? comparator.compare(value, this.lowerBound) < 0 : comparator.compare(value, this.lowerBound) <= 0)) {
                return false;
            }
            return this.upperBound == null || !(this.upperBoundIncluded ? comparator.compare(value, this.upperBound) > 0 : comparator.compare(value, this.upperBound) >= 0);
        }

        static class NumberAwareComparableComparator<T extends Comparable<T>>
        extends ComparableComparator<T> {
            NumberAwareComparableComparator() {
            }

            @Override
            public int compare(T o1, T o2) {
                if (Number.class.isInstance(o1) && Number.class.isInstance(o2)) {
                    return this.compareNumbers((Number)o1, (Number)o2);
                }
                return super.compare(o1, o2);
            }

            protected int compareNumbers(Number n1, Number n2) {
                BigDecimal bd1 = this.toDecimal(n1);
                BigDecimal bd2 = this.toDecimal(n2);
                return bd1.compareTo(bd2);
            }

            private BigDecimal toDecimal(Number n) {
                if (n instanceof BigDecimal) {
                    return (BigDecimal)n;
                }
                if (n instanceof BigInteger) {
                    return new BigDecimal((BigInteger)n);
                }
                if (n instanceof Float || n instanceof Double) {
                    return new BigDecimal(n.toString());
                }
                return new BigDecimal(n.longValue());
            }
        }
    }

    private static final class BetweenDateCondition
    extends AbstractDateCondition {
        private boolean earlierIncluded;
        private boolean laterIncluded;
        private Date earlier;
        private Date later;

        public BetweenDateCondition(Date earlier, Date later, boolean earlierIncluded, boolean laterIncluded) {
            Assert.isTrue((earlier != null || later != null ? 1 : 0) != 0, (String)"BetweenDateCondition cannot be initialized with both null earlier and null later calender");
            this.earlier = earlier;
            this.later = later;
            this.earlierIncluded = earlierIncluded;
            this.laterIncluded = laterIncluded;
        }

        public BetweenDateCondition(Calendar earlier, Calendar later, boolean earlierIncluded, boolean laterIncluded) {
            Assert.isTrue((earlier != null || later != null ? 1 : 0) != 0, (String)"BetweenDateCondition cannot be initialized with both null earlier and null later calender");
            this.earlier = earlier.getTime();
            this.later = later.getTime();
            this.earlierIncluded = earlierIncluded;
            this.laterIncluded = laterIncluded;
        }

        @Override
        protected boolean checkDate(Date calendar) {
            if (this.earlier != null && (this.earlierIncluded ? this.earlier.getTime() > calendar.getTime() : this.earlier.getTime() >= calendar.getTime())) {
                return false;
            }
            return this.later == null || !(this.laterIncluded ? this.later.getTime() < calendar.getTime() : this.later.getTime() <= calendar.getTime());
        }
    }

    private static final class SameCondition
    extends AbstractCondition {
        private Object obj;

        public SameCondition(Object obj) {
            this.obj = obj;
        }

        @Override
        protected boolean doCheck(Object obj) {
            return this.obj == obj;
        }
    }

    private static final class RegExpCondition
    extends AbstractCondition {
        private final Pattern pattern;

        public RegExpCondition(String regexp) {
            Assert.notNull((Object)regexp, (String)"The given regular expression cannot be null");
            this.pattern = Pattern.compile(regexp);
        }

        @Override
        protected boolean doCheck(Object text) {
            return this.pattern.matcher((String)text).matches();
        }
    }

    private static final class RFC822Condition
    extends AbstractCondition {
        private RFC822Condition() {
        }

        @Override
        protected boolean doCheck(Object text) {
            try {
                InternetAddress.parse((String)((String)text), (boolean)true);
                return true;
            }
            catch (AddressException addressException) {
                return false;
            }
        }
    }

    private static final class InCondition
    extends AbstractCondition {
        private Object[] objs;

        public InCondition(Object[] objs) {
            Assert.notNull((Object)objs, (String)"in array cannot be null");
            this.objs = objs;
        }

        @Override
        protected boolean doCheck(Object obj) {
            for (Object obj0 : this.objs) {
                if (!obj0.equals(obj)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class AndCondition
    extends AbstractCompoundCondition {
        public AndCondition(Condition[] conditions) {
            super(conditions);
        }

        public AndCondition(Collection<Condition> conditions) {
            super(conditions);
        }

        @Override
        protected boolean doCheck(Object object) {
            for (int i = 0; i < this.conditions.length; ++i) {
                if (this.conditions[i].check(object)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class OrCondition
    extends AbstractCompoundCondition {
        public OrCondition(Condition[] conditions) {
            super(conditions);
        }

        public OrCondition(Collection<Condition> conditions) {
            super(conditions);
        }

        @Override
        protected boolean doCheck(Object object) {
            for (int i = 0; i < this.conditions.length; ++i) {
                if (!this.conditions[i].check(object)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class NotCondition
    extends ProxyCondition {
        public NotCondition(Condition condition) {
            super(condition);
        }

        @Override
        protected boolean doCheck(Object object) {
            return !super.doCheck(object);
        }
    }

    private static final class AtMostCollectionCondition
    extends AbstractCollectionElementCondition {
        private int count;

        public AtMostCollectionCondition(Condition elementCondition, int count) {
            super(elementCondition);
            Assert.isTrue((count >= 0 ? 1 : 0) != 0, (String)"Count cannot be negative");
            this.count = count;
        }

        @Override
        protected boolean checkArray(Object array) {
            int counter = 0;
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (!this.elementCondition.check(Array.get(array, i)) || ++counter <= this.count) continue;
                return false;
            }
            return counter <= this.count;
        }

        @Override
        protected boolean checkCollection(Collection<?> collection) {
            int counter = 0;
            Iterator<?> iter = collection.iterator();
            while (iter.hasNext()) {
                if (!this.elementCondition.check(iter.next()) || ++counter <= this.count) continue;
                return false;
            }
            return counter <= this.count;
        }
    }

    private static final class AtLeastCollectionCondition
    extends AbstractCollectionElementCondition {
        private int count;

        public AtLeastCollectionCondition(Condition elementCondition, int count) {
            super(elementCondition);
            Assert.isTrue((count >= 0 ? 1 : 0) != 0, (String)"Count cannot be negative");
            this.count = count;
        }

        @Override
        protected boolean checkArray(Object array) {
            int counter = 0;
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (!this.elementCondition.check(Array.get(array, i)) || ++counter < this.count) continue;
                return true;
            }
            return counter >= this.count;
        }

        @Override
        protected boolean checkCollection(Collection<?> collection) {
            int counter = 0;
            Iterator<?> iter = collection.iterator();
            while (iter.hasNext()) {
                if (!this.elementCondition.check(iter.next()) || ++counter < this.count) continue;
                return true;
            }
            return counter >= this.count;
        }
    }

    private static final class AnyCollectionCondition
    extends AbstractCollectionElementCondition {
        public AnyCollectionCondition(Condition elementCondition) {
            super(elementCondition);
        }

        @Override
        protected boolean checkArray(Object array) {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (!this.elementCondition.check(Array.get(array, i))) continue;
                return true;
            }
            return false;
        }

        @Override
        protected boolean checkCollection(Collection<?> collection) {
            Iterator<?> iter = collection.iterator();
            while (iter.hasNext()) {
                if (!this.elementCondition.check(iter.next())) continue;
                return true;
            }
            return false;
        }
    }

    private static final class NoneCollectionCondition
    extends AbstractCollectionElementCondition {
        public NoneCollectionCondition(Condition elementCondition) {
            super(elementCondition);
        }

        @Override
        protected boolean checkArray(Object array) {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (!this.elementCondition.check(Array.get(array, i))) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean checkCollection(Collection<?> collection) {
            Iterator<?> iter = collection.iterator();
            while (iter.hasNext()) {
                if (!this.elementCondition.check(iter.next())) continue;
                return false;
            }
            return true;
        }
    }

    private static final class AllCollectionCondition
    extends AbstractCollectionElementCondition {
        public AllCollectionCondition(Condition elementCondition) {
            super(elementCondition);
        }

        @Override
        protected boolean checkArray(Object array) {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (this.elementCondition.check(Array.get(array, i))) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean checkCollection(Collection<?> collection) {
            Iterator<?> iter = collection.iterator();
            while (iter.hasNext()) {
                if (this.elementCondition.check(iter.next())) continue;
                return false;
            }
            return true;
        }
    }

    private static final class MapEntryCondition
    extends AbstractMapCondition {
        private String entryKey;
        private Condition entryCondition;

        public MapEntryCondition(String entryKey, Condition entryCondition) {
            Assert.notNull((Object)entryKey, (String)"Entry key cannot be null");
            Assert.notNull((Object)entryCondition, (String)"Entry condition cannot be null");
            this.entryKey = entryKey;
            this.entryCondition = entryCondition;
        }

        @Override
        protected boolean checkMap(Map<String, ?> map) {
            Object value = map.get(this.entryKey);
            return this.entryCondition.check(value);
        }
    }

    private static final class BeanPropertyCondition
    extends AbstractBeanCondition {
        private String propertyName;
        private Condition propertyCondition;

        public BeanPropertyCondition(String propertyName, Condition propertyCondition) {
            Assert.notNull((Object)propertyName, (String)"Property name cannot be null");
            Assert.notNull((Object)propertyCondition, (String)"Property condition cannot be null");
            this.propertyName = propertyName;
            this.propertyCondition = propertyCondition;
        }

        @Override
        protected boolean checkBean(BeanWrapper bean) {
            Object value = bean.getPropertyValue(this.propertyName);
            return this.propertyCondition.check(value);
        }
    }
}

