/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.crypto;

import com.cntaiping.ec.cloud.common.exception.TPSCBPError;
import com.cntaiping.ec.cloud.common.utils.crypto.AESAlgorithms;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tomcat.util.codec.binary.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AESUtils.class);
    private static final String ALGORITHM = "AES";
    private static final String SECURE_RANDOM_ALGORITHM = "SHA1PRNG";
    private static final int CBC_IV_LENGTH = 16;
    private static final int GCM_IV_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 16;
    private final Cipher cipher;

    private AESUtils(Cipher cipher) {
        this.cipher = cipher;
    }

    private AESUtils(boolean encrypt, String algorithm, Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            int cipherMode = encrypt ? 1 : 2;
            Cipher cipher = Cipher.getInstance(algorithm);
            if (algorithmParameterSpec != null) {
                cipher.init(cipherMode, key, algorithmParameterSpec);
            } else {
                cipher.init(cipherMode, key);
            }
            this.cipher = cipher;
        }
        catch (Exception e) {
            throw TPSCBPError.INVALID_ALGORITHM_PARAMETER.getInfo().initialize(e);
        }
    }

    public static AESUtils getInstance(boolean encrypt, String algorithm, Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        return new AESUtils(encrypt, algorithm, key, algorithmParameterSpec);
    }

    public static AESUtils getInstance(boolean encrypt, AESAlgorithms algorithm, Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        return new AESUtils(encrypt, algorithm.getAlgorithm(), key, algorithmParameterSpec);
    }

    public static AESUtils getInstance(boolean encrypt, AESAlgorithms algorithm, byte[] key, byte[] iv) {
        return new AESUtils(encrypt, algorithm.getAlgorithm(), AESUtils.restoreKey(key), AESUtils.ivParameter(algorithm, iv));
    }

    public static AESUtils getInstance4String(boolean encrypt, AESAlgorithms algorithm, String stringKey, String stringIv) {
        return new AESUtils(encrypt, algorithm.getAlgorithm(), AESUtils.restoreStringKey(stringKey), AESUtils.strToIvParameter(algorithm, stringIv));
    }

    public static AESUtils getInstance4Base64(boolean encrypt, AESAlgorithms algorithm, String base64Key, String base64Iv) {
        return new AESUtils(encrypt, algorithm.getAlgorithm(), AESUtils.restoreBase64Key(base64Key), AESUtils.base64ToIvParameter(algorithm, base64Iv));
    }

    public static AESUtils getInstance4Base64UrlSafe(boolean encrypt, AESAlgorithms algorithm, String base64UrlSafeKey, String base64UrlSafeIv) {
        return new AESUtils(encrypt, algorithm.getAlgorithm(), AESUtils.restoreBase64UrlSafeKey(base64UrlSafeKey), AESUtils.base64UrlSafeToIvParameter(algorithm, base64UrlSafeIv));
    }

    public static AESUtils getInstance4Hex(boolean encrypt, AESAlgorithms algorithm, String hexKey, String hexIv) {
        return new AESUtils(encrypt, algorithm.getAlgorithm(), AESUtils.restoreHexKey(hexKey), AESUtils.hexToIvParameter(algorithm, hexIv));
    }

    public static byte[] generateRandomBytes(int length) {
        byte[] bytes = new byte[length];
        SecureRandom random = new SecureRandom();
        random.nextBytes(bytes);
        return bytes;
    }

    public static String serializeString(Key key) {
        return AESUtils.serializeString(key.getEncoded());
    }

    public static String serializeString(byte[] encoded) {
        return new String(encoded, StandardCharsets.UTF_8);
    }

    public static String serializeBase64String(Key key) {
        return AESUtils.serializeBase64String(key.getEncoded());
    }

    public static String serializeBase64String(byte[] encoded) {
        return Base64.getEncoder().encodeToString(encoded);
    }

    public static String serializeBase64UrlSafeString(Key key) {
        return AESUtils.serializeBase64UrlSafeString(key.getEncoded());
    }

    public static String serializeBase64UrlSafeString(byte[] encoded) {
        return Base64.getUrlEncoder().encodeToString(encoded);
    }

    public static String serializeHexString(Key key) {
        return AESUtils.serializeHexString(key.getEncoded());
    }

    public static String serializeHexString(byte[] encoded) {
        return Hex.toHexString((byte[])encoded);
    }

    public static Key deserializeStringToKey(String str) {
        return new SecretKeySpec(AESUtils.deserializeStringToBytes(str), ALGORITHM);
    }

    public static byte[] deserializeStringToBytes(String str) {
        return StringUtils.getBytesUtf8((String)str);
    }

    public static Key deserializeBase64StringToKey(String base64String) {
        return new SecretKeySpec(AESUtils.deserializeBase64StringToBytes(base64String), ALGORITHM);
    }

    public static byte[] deserializeBase64StringToBytes(String base64String) {
        return Base64.getDecoder().decode(base64String);
    }

    public static Key deserializeBase64UrlSafeStringToKey(String base64UrlSafeString) {
        return new SecretKeySpec(AESUtils.deserializeBase64UrlSafeStringToBytes(base64UrlSafeString), ALGORITHM);
    }

    public static byte[] deserializeBase64UrlSafeStringToBytes(String base64UrlSafeString) {
        return Base64.getUrlDecoder().decode(base64UrlSafeString);
    }

    public static Key deserializeHexStringToKey(String hexString) {
        return new SecretKeySpec(AESUtils.deserializeHexStringToBytes(hexString), ALGORITHM);
    }

    public static byte[] deserializeHexStringToBytes(String hexString) {
        return Hex.decode((String)hexString);
    }

    public static AlgorithmParameterSpec ivParameter(AESAlgorithms algorithm, byte[] ivData) {
        if (algorithm.getMode() == AESAlgorithms.Mode.GCM) {
            return new GCMParameterSpec(128, ivData);
        }
        return new IvParameterSpec(ivData);
    }

    public static AlgorithmParameterSpec strToIvParameter(AESAlgorithms algorithm, String str) {
        return AESUtils.ivParameter(algorithm, AESUtils.deserializeStringToBytes(str));
    }

    public static AlgorithmParameterSpec hexToIvParameter(AESAlgorithms algorithm, String hexString) {
        return AESUtils.ivParameter(algorithm, AESUtils.deserializeHexStringToBytes(hexString));
    }

    public static AlgorithmParameterSpec base64ToIvParameter(AESAlgorithms algorithm, String base64String) {
        return AESUtils.ivParameter(algorithm, AESUtils.deserializeBase64StringToBytes(base64String));
    }

    public static AlgorithmParameterSpec base64UrlSafeToIvParameter(AESAlgorithms algorithm, String base64UrlSafeString) {
        return AESUtils.ivParameter(algorithm, AESUtils.deserializeBase64UrlSafeStringToBytes(base64UrlSafeString));
    }

    public static byte[] initIvParameter(int length) {
        return AESUtils.generateRandomBytes(length);
    }

    public static String initIvParameterString(int length) {
        return AESUtils.serializeString(AESUtils.initIvParameter(length));
    }

    public static String initIvParameterBase64(int length) {
        return AESUtils.serializeBase64String(AESUtils.initIvParameter(length));
    }

    public static String initIvParameterBase64UrlSafe(int length) {
        return AESUtils.serializeBase64UrlSafeString(AESUtils.initIvParameter(length));
    }

    public static String initIvParameterHex(int length) {
        return AESUtils.serializeHexString(AESUtils.initIvParameter(length));
    }

    public static AlgorithmParameterSpec newIvParameter(AESAlgorithms aesAlgorithms) {
        AESAlgorithms.Mode mode = aesAlgorithms.getMode();
        if (mode == AESAlgorithms.Mode.GCM) {
            return new GCMParameterSpec(128, AESUtils.initIvParameter(12));
        }
        return new IvParameterSpec(AESUtils.initIvParameter(16));
    }

    public static byte[] newIvParameterBytes(AESAlgorithms aesAlgorithms) {
        AESAlgorithms.Mode mode = aesAlgorithms.getMode();
        if (mode == AESAlgorithms.Mode.GCM) {
            return AESUtils.initIvParameter(12);
        }
        return AESUtils.initIvParameter(16);
    }

    public static String newIvParameterString(AESAlgorithms aesAlgorithms) {
        AESAlgorithms.Mode mode = aesAlgorithms.getMode();
        if (mode == AESAlgorithms.Mode.GCM) {
            return AESUtils.serializeString(AESUtils.initIvParameter(12));
        }
        return AESUtils.serializeString(AESUtils.initIvParameter(16));
    }

    public static String newIvParameterBase64(AESAlgorithms aesAlgorithms) {
        AESAlgorithms.Mode mode = aesAlgorithms.getMode();
        if (mode == AESAlgorithms.Mode.GCM) {
            return AESUtils.serializeBase64String(AESUtils.initIvParameter(12));
        }
        return AESUtils.serializeBase64String(AESUtils.initIvParameter(16));
    }

    public static String newIvParameterBase64UrlSafe(AESAlgorithms aesAlgorithms) {
        AESAlgorithms.Mode mode = aesAlgorithms.getMode();
        if (mode == AESAlgorithms.Mode.GCM) {
            return AESUtils.serializeBase64UrlSafeString(AESUtils.initIvParameter(12));
        }
        return AESUtils.serializeBase64UrlSafeString(AESUtils.initIvParameter(16));
    }

    public static String newIvParameterHex(AESAlgorithms aesAlgorithms) {
        AESAlgorithms.Mode mode = aesAlgorithms.getMode();
        if (mode == AESAlgorithms.Mode.GCM) {
            return AESUtils.serializeHexString(AESUtils.initIvParameter(12));
        }
        return AESUtils.serializeHexString(AESUtils.initIvParameter(16));
    }

    public static Key generateAESKey(int bitLen) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
            SecureRandom random = new SecureRandom();
            keyGenerator.init(bitLen, random);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw TPSCBPError.NO_SUCH_ALGORITHM.getInfo().initialize(e);
        }
    }

    public static byte[] initAESKey(int bitLen) {
        return AESUtils.generateAESKey(bitLen).getEncoded();
    }

    public static String initAESKeyString(int bitLen) {
        return AESUtils.serializeString(AESUtils.initAESKey(bitLen));
    }

    public static String initAESKeyBase64(int bitLen) {
        return AESUtils.serializeBase64String(AESUtils.initAESKey(bitLen));
    }

    public static String initAESKeyBase64UrlSafe(int bitLen) {
        return AESUtils.serializeBase64UrlSafeString(AESUtils.initAESKey(bitLen));
    }

    public static String initAESKeyHex(int bitLen) {
        return AESUtils.serializeHexString(AESUtils.initAESKey(bitLen));
    }

    public static SecretKey restoreKey(byte[] encoded) {
        return new SecretKeySpec(encoded, ALGORITHM);
    }

    public static SecretKey restoreStringKey(String str) {
        return new SecretKeySpec(AESUtils.deserializeStringToBytes(str), ALGORITHM);
    }

    public static SecretKey restoreBase64Key(String base64String) {
        return new SecretKeySpec(AESUtils.deserializeBase64StringToBytes(base64String), ALGORITHM);
    }

    public static SecretKey restoreBase64UrlSafeKey(String base64UrlSafeString) {
        return new SecretKeySpec(AESUtils.deserializeBase64UrlSafeStringToBytes(base64UrlSafeString), ALGORITHM);
    }

    public static SecretKey restoreHexKey(String hexString) {
        return new SecretKeySpec(AESUtils.deserializeHexStringToBytes(hexString), ALGORITHM);
    }

    public static SecretKey restoreKey(int bitLen, byte[] seed) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
            SecureRandom random = SecureRandom.getInstance(SECURE_RANDOM_ALGORITHM);
            random.setSeed(seed);
            keyGenerator.init(bitLen, random);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw TPSCBPError.NO_SUCH_ALGORITHM.getInfo().initialize(e);
        }
    }

    public static SecretKey restoreStringKey(int bitLen, String str) {
        return AESUtils.restoreKey(bitLen, AESUtils.deserializeStringToBytes(str));
    }

    public static SecretKey restoreBase64Key(int bitLen, String base64String) {
        return AESUtils.restoreKey(bitLen, AESUtils.deserializeBase64StringToBytes(base64String));
    }

    public static SecretKey restoreBase64UrlSafeKey(int bitLen, String base64UrlSafeString) {
        return AESUtils.restoreKey(bitLen, AESUtils.deserializeBase64UrlSafeStringToBytes(base64UrlSafeString));
    }

    public static SecretKey restoreHexKey(int bitLen, String hexString) {
        return AESUtils.restoreKey(bitLen, AESUtils.deserializeHexStringToBytes(hexString));
    }

    public byte[] doFinal(byte[] data) {
        try {
            return this.cipher.doFinal(data);
        }
        catch (Exception e) {
            throw TPSCBPError.CIPHER_ERROR.getInfo().initialize(e);
        }
    }

    public String doFinal2String(byte[] data) {
        return AESUtils.serializeString(this.doFinal(data));
    }

    public String doFinal2Base64(byte[] data) {
        return AESUtils.serializeBase64String(this.doFinal(data));
    }

    public String doFinal2Base64UrlSafe(byte[] data) {
        return AESUtils.serializeBase64UrlSafeString(this.doFinal(data));
    }

    public String doFinal2Hex(byte[] data) {
        return AESUtils.serializeHexString(this.doFinal(data));
    }

    public byte[] doFinal4String2Bytes(String data) {
        return this.doFinal(AESUtils.deserializeStringToBytes(data));
    }

    public String doFinal4String2String(String str) {
        return AESUtils.serializeString(this.doFinal(AESUtils.deserializeStringToBytes(str)));
    }

    public String doFinal4Base642Base64(String base64) {
        return AESUtils.serializeBase64String(this.doFinal(AESUtils.deserializeBase64StringToBytes(base64)));
    }

    public String doFinal4Base64UrlSafe2Base64UrlSafe(String base64UrlSafe) {
        return AESUtils.serializeBase64UrlSafeString(this.doFinal(AESUtils.deserializeBase64StringToBytes(base64UrlSafe)));
    }

    public String doFinal4Hex2Hex(String hex) {
        return AESUtils.serializeHexString(this.doFinal(AESUtils.deserializeHexStringToBytes(hex)));
    }

    public String doFinal4Base642String(String base64) {
        return AESUtils.serializeString(this.doFinal(AESUtils.deserializeBase64StringToBytes(base64)));
    }

    public String doFinal4Base64UrlSafe2String(String base64UrlSafe) {
        return AESUtils.serializeString(this.doFinal(AESUtils.deserializeBase64StringToBytes(base64UrlSafe)));
    }

    public String doFinal4Hex2String(String hex) {
        return AESUtils.serializeString(this.doFinal(AESUtils.deserializeHexStringToBytes(hex)));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

