/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.crypto;

import com.cntaiping.ec.cloud.common.exception.TPSCBPError;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;

public class KeystoreUtils {
    private static final String STORE_TYPE_PKCS12 = "PKCS12";
    private static final String STORE_TYPE_JKS = "JKS";

    public static KeyStore loadPkcs12KeyStore(String path, String storePass) {
        return KeystoreUtils.loadKeyStore(STORE_TYPE_PKCS12, path, storePass);
    }

    public static KeyStore loadJksKeyStore(String path, String storePass) {
        return KeystoreUtils.loadKeyStore(STORE_TYPE_JKS, path, storePass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore loadKeyStore(String storeType, String path, String storePass) {
        try (FileInputStream inputStream = new FileInputStream(new File(path));){
            KeyStore keyStore = KeyStore.getInstance(storeType);
            keyStore.load(inputStream, storePass.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (Exception e) {
            throw TPSCBPError.KEYSTORE_INSTANCE.getInfo().initialize(e);
        }
    }

    public static PrivateKey getRSAPrivateKey(KeyStore keyStore, String alias, String keyPass) {
        try {
            return (PrivateKey)keyStore.getKey(alias, keyPass.toCharArray());
        }
        catch (Exception e) {
            throw TPSCBPError.RSA_PRIVATEKEY_INSTANCE.getInfo().initialize(e);
        }
    }

    public static Certificate getCertificate(KeyStore keyStore, String alias) {
        try {
            return keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw TPSCBPError.CERTIFICATE_INSTANCE.getInfo().initialize(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static Certificate loadCertificate(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static PublicKey getPublicKey(Certificate certificate) {
        return certificate.getPublicKey();
    }
}

