/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.crypto;

import java.util.Arrays;
import java.util.Base64;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.tomcat.util.codec.binary.StringUtils;
import org.bouncycastle.util.encoders.Hex;

public class PRFUtils {
    private static final byte[] MASTER_LABEL = new byte[]{109, 97, 115, 116, 101, 114, 32, 115, 101, 99, 114, 101, 116};
    private static final byte[] KEY_BLOCK_LABEL = new byte[]{107, 101, 121, 32, 101, 120, 112, 97, 110, 115, 105, 111, 110};

    public static byte[] prf(byte[] key, byte[] label, byte[] seed, int numBlocks) {
        if (key == null || label == null || seed == null || numBlocks == 0) {
            throw new IllegalArgumentException();
        }
        byte[] newSeed = new byte[label.length + seed.length];
        System.arraycopy(label, 0, newSeed, 0, label.length);
        System.arraycopy(seed, 0, newSeed, label.length, seed.length);
        HmacUtils hmacUtils = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, key);
        byte[] digest = hmacUtils.hmac(newSeed);
        byte[] output = new byte[]{};
        for (int i = 0; i < numBlocks; ++i) {
            byte[] toDigest = new byte[digest.length + newSeed.length];
            System.arraycopy(digest, 0, toDigest, 0, digest.length);
            System.arraycopy(newSeed, 0, toDigest, digest.length, newSeed.length);
            byte[] out = hmacUtils.hmac(toDigest);
            byte[] newOutput = new byte[output.length + out.length];
            System.arraycopy(output, 0, newOutput, 0, output.length);
            System.arraycopy(out, 0, newOutput, output.length, out.length);
            output = newOutput;
            digest = hmacUtils.hmac(digest);
        }
        return output;
    }

    public static byte[] generateMasterSecret(byte[] pms, byte[] rnc, byte[] rns) {
        if (pms == null || rnc == null || rns == null) {
            throw new IllegalArgumentException();
        }
        byte[] seed = new byte[rnc.length + rns.length];
        System.arraycopy(rnc, 0, seed, 0, rnc.length);
        System.arraycopy(rns, 0, seed, rnc.length, rns.length);
        byte[] randoms = PRFUtils.prf(pms, MASTER_LABEL, seed, 2);
        byte[] ms = new byte[48];
        System.arraycopy(randoms, 0, ms, 0, ms.length);
        return ms;
    }

    public static byte[][] generateKeyBlock(byte[] ms, byte[] rnc, byte[] rns) {
        if (ms == null || rnc == null || rns == null) {
            throw new IllegalArgumentException();
        }
        byte[] seed = new byte[rnc.length + rns.length];
        System.arraycopy(rnc, 0, seed, 0, rnc.length);
        System.arraycopy(rns, 0, seed, rnc.length, rns.length);
        byte[] randoms = PRFUtils.prf(ms, KEY_BLOCK_LABEL, seed, 5);
        byte[][] keyBlock = new byte[][]{Arrays.copyOfRange(randoms, 0, 32), Arrays.copyOfRange(randoms, 32, 64), Arrays.copyOfRange(randoms, 64, 96), Arrays.copyOfRange(randoms, 96, 128), Arrays.copyOfRange(randoms, 128, 144), Arrays.copyOfRange(randoms, 144, 160)};
        return keyBlock;
    }

    public static byte[][] generateKeyBlock4Base64String(String pms, String rnc, String rns) {
        byte[] rncBytes = Base64.getDecoder().decode(rnc);
        byte[] rnsBytes = Base64.getDecoder().decode(rns);
        byte[] ms = PRFUtils.generateMasterSecret(Base64.getDecoder().decode(pms), rncBytes, rnsBytes);
        return PRFUtils.generateKeyBlock(ms, rncBytes, rnsBytes);
    }

    public static byte[][] generateKeyBlock4Base64UrlSafeString(String pms, String rnc, String rns) {
        byte[] rncBytes = Base64.getUrlDecoder().decode(rnc);
        byte[] rnsBytes = Base64.getUrlDecoder().decode(rns);
        byte[] ms = PRFUtils.generateMasterSecret(Base64.getUrlDecoder().decode(pms), rncBytes, rnsBytes);
        return PRFUtils.generateKeyBlock(ms, rncBytes, rnsBytes);
    }

    public static byte[][] generateKeyBlock4HexString(String pms, String rnc, String rns) {
        byte[] rncBytes = Hex.decode((String)rnc);
        byte[] rnsBytes = Hex.decode((String)rns);
        byte[] ms = PRFUtils.generateMasterSecret(Hex.decode((String)pms), rncBytes, rnsBytes);
        return PRFUtils.generateKeyBlock(ms, rncBytes, rnsBytes);
    }

    public static byte[][] generateKeyBlock4String(String pms, String rnc, String rns) {
        byte[] rncBytes = StringUtils.getBytesUtf8((String)rnc);
        byte[] rnsBytes = StringUtils.getBytesUtf8((String)rns);
        byte[] ms = PRFUtils.generateMasterSecret(StringUtils.getBytesUtf8((String)pms), rncBytes, rnsBytes);
        return PRFUtils.generateKeyBlock(ms, rncBytes, rnsBytes);
    }
}

