/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.crypto;

import com.cntaiping.ec.cloud.common.exception.TPSCBPError;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;

public class PemOrDerUtils {
    private static final String ALGORITHM = "RSA";

    private PemOrDerUtils() {
    }

    public static PrivateKey readUnencryptedPKCS1PEMRSAPrivateKeyByPEMParser(String fileName) {
        return PemOrDerUtils.readPEMRSAPrivateKeyByPEMParser(fileName, null);
    }

    public static PrivateKey readEncryptedPKCS1PEMRSAPrivateKeyByPEMParser(String fileName, String password) {
        return PemOrDerUtils.readPEMRSAPrivateKeyByPEMParser(fileName, password);
    }

    public static PrivateKey readUnencryptedPKCS8PEMRSAPrivateKeyByPEMParser(String fileName) {
        return PemOrDerUtils.readPEMRSAPrivateKeyByPEMParser(fileName, null);
    }

    public static PrivateKey readEncryptedPKCS8PEMRSAPrivateKeyByPEMParser(String fileName, String password) {
        return PemOrDerUtils.readPEMRSAPrivateKeyByPEMParser(fileName, password);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey readPEMRSAPrivateKeyByPEMParser(String fileName, String password) {
        try (PEMParser pemParser = new PEMParser((Reader)new FileReader(fileName));){
            Object object = pemParser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            KeyPair keyPair = null;
            if (object instanceof PEMEncryptedKeyPair) {
                if (password == null) {
                    throw new IllegalArgumentException("password must not be null");
                }
                PEMEncryptedKeyPair pemEncryptedKeyPair = (PEMEncryptedKeyPair)object;
                PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
                keyPair = converter.getKeyPair(pemEncryptedKeyPair.decryptKeyPair(decryptorProvider));
                PrivateKey privateKey = keyPair.getPrivate();
                return privateKey;
            }
            if (object instanceof PEMKeyPair) {
                PEMKeyPair pemKeyPair = (PEMKeyPair)object;
                keyPair = converter.getKeyPair(pemKeyPair);
                PrivateKey decryptorProvider = keyPair.getPrivate();
                return decryptorProvider;
            }
            if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                if (password == null) {
                    throw new IllegalArgumentException("password must not be null");
                }
                PKCS8EncryptedPrivateKeyInfo pkcs8EncryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)object;
                InputDecryptorProvider decryptionProv = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(password.toCharArray());
                PrivateKeyInfo keyInfo = pkcs8EncryptedPrivateKeyInfo.decryptPrivateKeyInfo(decryptionProv);
                PrivateKey privateKey = converter.getPrivateKey(keyInfo);
                return privateKey;
            }
            if (object instanceof PrivateKeyInfo) {
                PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)object;
                PrivateKey privateKey = converter.getPrivateKey(privateKeyInfo);
                return privateKey;
            }
            throw new IllegalStateException("Illegal State: " + object);
        }
        catch (IOException | OperatorCreationException | PKCSException e) {
            throw TPSCBPError.READING_RSAPRIVATEKEY.getInfo().initialize(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PublicKey readPEMRSAPublicKeyByPEMParser(String fileName) {
        try (PEMParser pemParser = new PEMParser((Reader)new FileReader(fileName));){
            Object object = pemParser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            if (object instanceof SubjectPublicKeyInfo) {
                SubjectPublicKeyInfo subjectPublicKeyInfo = (SubjectPublicKeyInfo)object;
                PublicKey publicKey = converter.getPublicKey(subjectPublicKeyInfo);
                return publicKey;
            }
            throw new IllegalStateException("Illegal State: " + object);
        }
        catch (IOException e) {
            throw TPSCBPError.READING_RSAPUBLICKEY.getInfo().initialize(e);
        }
    }

    public static PrivateKey readUnencryptedPKCS8DERRSAPrivateKey(String fileName) {
        try {
            byte[] keyBytes = Files.readAllBytes(Paths.get(fileName, new String[0]));
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory kf = KeyFactory.getInstance(ALGORITHM);
            return kf.generatePrivate(spec);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw TPSCBPError.READING_RSAPRIVATEKEY.getInfo().initialize(e);
        }
    }

    public static PrivateKey readEncryptedPKCS8DERRSAPrivateKey(String fileName, String password) {
        try {
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            byte[] keyBytes = Files.readAllBytes(Paths.get(fileName, new String[0]));
            PKCS8EncryptedPrivateKeyInfo pkcs8EncryptedPrivateKeyInfo = new PKCS8EncryptedPrivateKeyInfo(keyBytes);
            InputDecryptorProvider decryptionProv = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(password.toCharArray());
            PrivateKeyInfo keyInfo = pkcs8EncryptedPrivateKeyInfo.decryptPrivateKeyInfo(decryptionProv);
            return converter.getPrivateKey(keyInfo);
        }
        catch (IOException | OperatorCreationException | PKCSException e) {
            throw TPSCBPError.READING_RSAPRIVATEKEY.getInfo().initialize(e);
        }
    }

    public static PublicKey readUnencryptedPKCS8DERRSAPublicKey(String fileName) {
        try {
            byte[] keyBytes = Files.readAllBytes(Paths.get(fileName, new String[0]));
            X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
            KeyFactory kf = KeyFactory.getInstance(ALGORITHM);
            return kf.generatePublic(spec);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw TPSCBPError.READING_RSAPUBLICKEY.getInfo().initialize(e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

