/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.crypto;

import com.cntaiping.ec.cloud.common.exception.TPSCBPError;
import com.cntaiping.ec.cloud.common.utils.crypto.SignatureAlgorithms;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.StringUtils;
import org.bouncycastle.util.encoders.Hex;

public class RSAUtils {
    private static final String ALGORITHM = "RSA";

    public static PublicKey getPublicKey(String publicKeyString) {
        return RSAUtils.getPublicKey(Base64.getDecoder().decode(publicKeyString));
    }

    public static PrivateKey getPrivateKey(String privateKeyString) {
        return RSAUtils.getPrivateKey(Base64.getDecoder().decode(privateKeyString));
    }

    public static PublicKey getPublicKey(byte[] publicKeyBytes) {
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKeyBytes);
            KeyFactory factory = KeyFactory.getInstance(ALGORITHM);
            return factory.generatePublic(x509EncodedKeySpec);
        }
        catch (Exception e) {
            throw TPSCBPError.READING_RSAPUBLICKEY.getInfo().initialize(e);
        }
    }

    public static PrivateKey getPrivateKey(byte[] privateKeyBytes) {
        try {
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
            KeyFactory factory = KeyFactory.getInstance(ALGORITHM);
            return factory.generatePrivate(pkcs8EncodedKeySpec);
        }
        catch (Exception e) {
            throw TPSCBPError.READING_RSAPUBLICKEY.getInfo().initialize(e);
        }
    }

    public static KeyPair generateKeyPair(int keySize) {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(ALGORITHM);
            keyPairGen.initialize(keySize);
            return keyPairGen.generateKeyPair();
        }
        catch (Exception e) {
            throw TPSCBPError.NO_SUCH_ALGORITHM.getInfo().initialize(e);
        }
    }

    public static String encodePrivateKey(PrivateKey privateKey) {
        return Base64.getEncoder().encodeToString(privateKey.getEncoded());
    }

    public static String encodePublicKey(PublicKey publicKey) {
        return Base64.getEncoder().encodeToString(publicKey.getEncoded());
    }

    public static String encodePrivateKey(KeyPair keyPair) {
        return Base64.getEncoder().encodeToString(keyPair.getPrivate().getEncoded());
    }

    public static String encodePublicKey(KeyPair keyPair) {
        return Base64.getEncoder().encodeToString(keyPair.getPublic().getEncoded());
    }

    public static String signSHA256withRSAByRSAPrivateKey2String(PrivateKey privateKey, byte[] data) {
        return new String(RSAUtils.signByRSAPrivateKey(SignatureAlgorithms.SHA256withRSA, privateKey, data), StandardCharsets.UTF_8);
    }

    public static String signSHA256withRSAByRSAPrivateKey2Base64String(PrivateKey privateKey, byte[] data) {
        return Base64.getEncoder().encodeToString(RSAUtils.signByRSAPrivateKey(SignatureAlgorithms.SHA256withRSA, privateKey, data));
    }

    public static String signSHA256withRSAByRSAPrivateKey2Base64UrlSafeString(PrivateKey privateKey, byte[] data) {
        return Base64.getUrlEncoder().encodeToString(RSAUtils.signByRSAPrivateKey(SignatureAlgorithms.SHA256withRSA, privateKey, data));
    }

    public static String signSHA256withRSAByRSAPrivateKey2HexString(PrivateKey privateKey, byte[] data) {
        return Hex.toHexString((byte[])RSAUtils.signByRSAPrivateKey(SignatureAlgorithms.SHA256withRSA, privateKey, data));
    }

    public static String signSHA256withRSAByRSAPrivateKeyString(PrivateKey privateKey, String data) {
        return new String(RSAUtils.signByRSAPrivateKey(SignatureAlgorithms.SHA256withRSA, privateKey, StringUtils.getBytesUtf8((String)data)), StandardCharsets.UTF_8);
    }

    public static String signSHA256withRSAByRSAPrivateKeyString2Base64String(PrivateKey privateKey, String data) {
        return Base64.getEncoder().encodeToString(RSAUtils.signByRSAPrivateKey(SignatureAlgorithms.SHA256withRSA, privateKey, StringUtils.getBytesUtf8((String)data)));
    }

    public static String signSHA256withRSAByRSAPrivateKeyString2Base64UrlSafeString(PrivateKey privateKey, String data) {
        return Base64.getUrlEncoder().encodeToString(RSAUtils.signByRSAPrivateKey(SignatureAlgorithms.SHA256withRSA, privateKey, StringUtils.getBytesUtf8((String)data)));
    }

    public static String signSHA256withRSAByRSAPrivateKeyString2HexString(PrivateKey privateKey, String data) {
        return Hex.toHexString((byte[])RSAUtils.signByRSAPrivateKey(SignatureAlgorithms.SHA256withRSA, privateKey, StringUtils.getBytesUtf8((String)data)));
    }

    public static boolean verifySHA256withRSASignByRSAPublicKeyString(PublicKey publicKey, String data, String sign) {
        return RSAUtils.verifySignByRSAPublicKey(SignatureAlgorithms.SHA256withRSA, publicKey, StringUtils.getBytesUtf8((String)data), StringUtils.getBytesUtf8((String)sign));
    }

    public static String signSHA256withRSAByRSAPrivateKeyBase64String(PrivateKey privateKey, String data) {
        return Base64.getEncoder().encodeToString(RSAUtils.signByRSAPrivateKey(SignatureAlgorithms.SHA256withRSA, privateKey, Base64.getDecoder().decode(data)));
    }

    public static boolean verifySHA256withRSASignByRSAPublicKeyBase64String(PublicKey publicKey, String data, String sign) {
        return RSAUtils.verifySignByRSAPublicKey(SignatureAlgorithms.SHA256withRSA, publicKey, Base64.getDecoder().decode(data), Base64.getDecoder().decode(sign));
    }

    public static String signSHA256withRSAByRSAPrivateKeyBase64UrlSafeString(PrivateKey privateKey, String data) {
        return Base64.getUrlEncoder().encodeToString(RSAUtils.signByRSAPrivateKey(SignatureAlgorithms.SHA256withRSA, privateKey, Base64.getUrlDecoder().decode(data)));
    }

    public static boolean verifySHA256withRSASignByRSAPublicKeyBase64UrlSafeString(PublicKey publicKey, String data, String sign) {
        return RSAUtils.verifySignByRSAPublicKey(SignatureAlgorithms.SHA256withRSA, publicKey, Base64.getUrlDecoder().decode(data), Base64.getUrlDecoder().decode(sign));
    }

    public static String signSHA256withRSAByRSAPrivateKeyHexString(PrivateKey privateKey, String data) {
        return Hex.toHexString((byte[])RSAUtils.signByRSAPrivateKey(SignatureAlgorithms.SHA256withRSA, privateKey, Hex.decode((String)data)));
    }

    public static boolean verifySHA256withRSASignByRSAPublicKeyHexString(PublicKey publicKey, String data, String sign) {
        return RSAUtils.verifySignByRSAPublicKey(SignatureAlgorithms.SHA256withRSA, publicKey, Hex.decode((String)data), Hex.decode((String)sign));
    }

    public static byte[] signSHA256withRSAByRSAPrivateKey(PrivateKey privateKey, byte[] data) {
        return RSAUtils.signByRSAPrivateKey(SignatureAlgorithms.SHA256withRSA, privateKey, data);
    }

    public static boolean verifySHA256withRSASignByRSAPublicKey(PublicKey publicKey, byte[] data, byte[] sign) {
        return RSAUtils.verifySignByRSAPublicKey(SignatureAlgorithms.SHA256withRSA, publicKey, data, sign);
    }

    public static String signByRSAPrivateKey2String(SignatureAlgorithms signatureAlgorithm, PrivateKey privateKey, byte[] data) {
        return new String(RSAUtils.signByRSAPrivateKey(signatureAlgorithm, privateKey, data), StandardCharsets.UTF_8);
    }

    public static String signByRSAPrivateKey2Base64String(SignatureAlgorithms signatureAlgorithm, PrivateKey privateKey, byte[] data) {
        return Base64.getEncoder().encodeToString(RSAUtils.signByRSAPrivateKey(signatureAlgorithm, privateKey, data));
    }

    public static String signByRSAPrivateKey2Base64UrlSafeString(SignatureAlgorithms signatureAlgorithm, PrivateKey privateKey, byte[] data) {
        return Base64.getUrlEncoder().encodeToString(RSAUtils.signByRSAPrivateKey(signatureAlgorithm, privateKey, data));
    }

    public static String signByRSAPrivateKey2HexString(SignatureAlgorithms signatureAlgorithm, PrivateKey privateKey, byte[] data) {
        return Hex.toHexString((byte[])RSAUtils.signByRSAPrivateKey(signatureAlgorithm, privateKey, data));
    }

    public static String signByRSAPrivateKeyString(SignatureAlgorithms signatureAlgorithm, PrivateKey privateKey, String data) {
        return new String(RSAUtils.signByRSAPrivateKey(signatureAlgorithm, privateKey, StringUtils.getBytesUtf8((String)data)), StandardCharsets.UTF_8);
    }

    public static String signByRSAPrivateKeyString2Base64String(SignatureAlgorithms signatureAlgorithm, PrivateKey privateKey, String data) {
        return Base64.getEncoder().encodeToString(RSAUtils.signByRSAPrivateKey(signatureAlgorithm, privateKey, StringUtils.getBytesUtf8((String)data)));
    }

    public static String signByRSAPrivateKeyString2Base64UrlSafeString(SignatureAlgorithms signatureAlgorithm, PrivateKey privateKey, String data) {
        return Base64.getUrlEncoder().encodeToString(RSAUtils.signByRSAPrivateKey(signatureAlgorithm, privateKey, StringUtils.getBytesUtf8((String)data)));
    }

    public static String signByRSAPrivateKeyString2HexString(SignatureAlgorithms signatureAlgorithm, PrivateKey privateKey, String data) {
        return Hex.toHexString((byte[])RSAUtils.signByRSAPrivateKey(signatureAlgorithm, privateKey, StringUtils.getBytesUtf8((String)data)));
    }

    public static boolean verifySignByRSAPublicKeyString(SignatureAlgorithms signatureAlgorithm, PublicKey publicKey, String data, String sign) {
        return RSAUtils.verifySignByRSAPublicKey(signatureAlgorithm, publicKey, StringUtils.getBytesUtf8((String)data), StringUtils.getBytesUtf8((String)sign));
    }

    public static boolean verifySignByRSAPublicKeyBase64String(SignatureAlgorithms signatureAlgorithm, PublicKey publicKey, String data, String sign) {
        return RSAUtils.verifySignByRSAPublicKey(signatureAlgorithm, publicKey, Base64.getDecoder().decode(data), Base64.getDecoder().decode(sign));
    }

    public static boolean verifySignByRSAPublicKeyBase64UrlSafeString(SignatureAlgorithms signatureAlgorithm, PublicKey publicKey, String data, String sign) {
        return RSAUtils.verifySignByRSAPublicKey(signatureAlgorithm, publicKey, Base64.getUrlDecoder().decode(data), Base64.getUrlDecoder().decode(sign));
    }

    public static boolean verifySignByRSAPublicKeyHexString(SignatureAlgorithms signatureAlgorithm, PublicKey publicKey, String data, String sign) {
        return RSAUtils.verifySignByRSAPublicKey(signatureAlgorithm, publicKey, Hex.decode((String)data), Hex.decode((String)sign));
    }

    public static byte[] signByRSAPrivateKey(SignatureAlgorithms signatureAlgorithm, PrivateKey privateKey, byte[] data) {
        try {
            Signature sign = Signature.getInstance(signatureAlgorithm.getAlgorithm());
            sign.initSign(privateKey);
            sign.update(data);
            return sign.sign();
        }
        catch (Exception e) {
            throw TPSCBPError.SIGNING.getInfo().initialize(e);
        }
    }

    public static boolean verifySignByRSAPublicKey(SignatureAlgorithms signatureAlgorithm, PublicKey publicKey, byte[] data, byte[] sign) {
        try {
            Signature signature = Signature.getInstance(signatureAlgorithm.getAlgorithm());
            signature.initVerify(publicKey);
            signature.update(data);
            return signature.verify(sign);
        }
        catch (Exception e) {
            throw TPSCBPError.VERIFY_SIGN.getInfo().initialize(e);
        }
    }

    public static String encryptByRSAPublicKey2String(PublicKey publicKey, byte[] data) {
        return new String(RSAUtils.encryptByRSAPublicKey(publicKey, data), StandardCharsets.UTF_8);
    }

    public static String encryptByRSAPublicKey2Base64String(PublicKey publicKey, byte[] data) {
        return Base64.getEncoder().encodeToString(RSAUtils.encryptByRSAPublicKey(publicKey, data));
    }

    public static String encryptByRSAPublicKey2Base64UrlSafeString(PublicKey publicKey, byte[] data) {
        return Base64.getUrlEncoder().encodeToString(RSAUtils.encryptByRSAPublicKey(publicKey, data));
    }

    public static String encryptByRSAPublicKey2HexString(PublicKey publicKey, byte[] data) {
        return Hex.toHexString((byte[])RSAUtils.encryptByRSAPublicKey(publicKey, data));
    }

    public static String encryptByRSAPublicKeyString(PublicKey publicKey, String data) {
        return new String(RSAUtils.encryptByRSAPublicKey(publicKey, StringUtils.getBytesUtf8((String)data)), StandardCharsets.UTF_8);
    }

    public static String encryptByRSAPublicKeyString2Base64String(PublicKey publicKey, String data) {
        return Base64.getEncoder().encodeToString(RSAUtils.encryptByRSAPublicKey(publicKey, StringUtils.getBytesUtf8((String)data)));
    }

    public static String encryptByRSAPublicKeyString2Base64UrlSafeString(PublicKey publicKey, String data) {
        return Base64.getUrlEncoder().encodeToString(RSAUtils.encryptByRSAPublicKey(publicKey, StringUtils.getBytesUtf8((String)data)));
    }

    public static String encryptByRSAPublicKeyString2HexString(PublicKey publicKey, String data) {
        return Hex.toHexString((byte[])RSAUtils.encryptByRSAPublicKey(publicKey, StringUtils.getBytesUtf8((String)data)));
    }

    public static String decryptByRSAPrivateKeyString(PrivateKey privateKey, String data) {
        return new String(RSAUtils.decryptByRSAPrivateKey(privateKey, StringUtils.getBytesUtf8((String)data)), StandardCharsets.UTF_8);
    }

    public static String decryptByRSAPrivateKey4Base64String(PrivateKey privateKey, String data) {
        return new String(RSAUtils.decryptByRSAPrivateKey(privateKey, Base64.getDecoder().decode(data)));
    }

    public static String decryptByRSAPrivateKey4Base64UrlSafeString(PrivateKey privateKey, String data) {
        return new String(RSAUtils.decryptByRSAPrivateKey(privateKey, Base64.getUrlDecoder().decode(data)));
    }

    public static String decryptByRSAPrivateKey4HexString(PrivateKey privateKey, String data) {
        return new String(RSAUtils.decryptByRSAPrivateKey(privateKey, Hex.decode((String)data)));
    }

    public static byte[] encryptByRSAPublicKey(PublicKey publicKey, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, publicKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw TPSCBPError.RSA_ENCRYPTION.getInfo().initialize(e);
        }
    }

    public static byte[] decryptByRSAPrivateKey(PrivateKey privateKey, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, privateKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw TPSCBPError.RSA_DECRYPTION.getInfo().initialize(e);
        }
    }
}

