/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.date;

import com.cntaiping.ec.cloud.common.utils.date.DateParseException;
import com.cntaiping.ec.cloud.common.utils.date.DateParser;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SmartDateParser
implements DateParser {
    private static SmartDateParser instance = new SmartDateParser();
    private Map<Pattern, Object> registrations = new LinkedHashMap<Pattern, Object>();

    public static SmartDateParser getInstance() {
        return instance;
    }

    public SmartDateParser() {
        this.register("^\\d{8}$", "yyyyMMdd");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}$", "yyyy-MM-dd");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}\\s+\\d{2}:\\d{2}$", "yyyy-MM-dd HH:mm");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}\\s+\\d{2}:\\d{2}:\\d{2}$", "yyyy-MM-dd HH:mm:ss");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}\\s+\\d{2}:\\d{2}:\\d{2}[\\+-]\\d{4}$", "yyyy-MM-dd HH:mm:ssZ");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}\\s+\\d{2}:\\d{2}:\\d{2}\\.\\d{3}$", "yyyy-MM-dd HH:mm:ss.SSS");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}\\s+\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+-]\\d{4}$$", "yyyy-MM-dd HH:mm:ss.SSSZ");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}T\\d{2}:\\d{2}:\\d{2}$", "yyyy-MM-dd'T'HH:mm:ss");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z$", "yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}T\\d{2}:\\d{2}:\\d{2}[\\+-]\\d{4}$", "yyyy-MM-dd'T'HH:mm:ssZ");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}$", "yyyy-MM-dd'T'HH:mm:ss.SSS");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}Z$", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.register("^\\d{4}\\-\\d{2}\\-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+-]\\d{4}$", "yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        this.register("^\\d{2}:\\d{2}:\\d{2}$", "HH:mm:ss");
        this.register("^\\d{2}:\\d{2}:\\d{2}[\\+-]\\d{4}$", "HH:mm:ssZ");
        this.register("^\\d{2}:\\d{2}:\\d{2}\\.\\d{3}$", "HH:mm:ss.SSS");
        this.register("^\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+-]\\d{4}$$", "HH:mm:ss.SSSZ");
        this.register("^\\d{2}:\\d{2}$", "HH:mm");
        this.register("^T$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
            }
        });
        this.register("^T\\+(\\d+)S$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(14, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)S$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(14, Integer.parseInt(value) * -1);
            }
        });
        this.register("^T>s$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(13, 1);
                calendar.add(14, calendar.get(14) * -1);
            }
        });
        this.register("^T<s$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(14, calendar.get(14) * -1);
            }
        });
        this.register("^T\\+(\\d+)s$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(13, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)s$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(13, Integer.parseInt(value) * -1);
            }
        });
        this.register("^T>m$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(12, 1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
            }
        });
        this.register("^T<m$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
            }
        });
        this.register("^T\\+(\\d+)m$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(12, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)m$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(12, Integer.parseInt(value) * -1);
            }
        });
        this.register("^T>H$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(11, 1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
            }
        });
        this.register("^T<H$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
            }
        });
        this.register("^T\\+(\\d+)H$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(11, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)H$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(11, Integer.parseInt(value) * -1);
            }
        });
        this.register("^T>d$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(6, 1);
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
            }
        });
        this.register("^T<d$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
            }
        });
        this.register("^T\\+(\\d+)d$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(6, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)d$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(6, Integer.parseInt(value) * -1);
            }
        });
        this.register("^T>w$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                int thisWeek = calendar.get(3);
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
                while (thisWeek == calendar.get(3)) {
                    calendar.add(6, 1);
                }
            }
        });
        this.register("^T<w$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                int thisWeek = calendar.get(3);
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
                while (thisWeek == calendar.get(3)) {
                    calendar.add(6, -1);
                }
                calendar.add(6, 1);
            }
        });
        this.register("^T\\+(\\d+)w$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(3, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)w$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(3, Integer.parseInt(value) * -1);
            }
        });
        this.register("^T>M$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                int thisMonth = calendar.get(2);
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
                while (thisMonth == calendar.get(2)) {
                    calendar.add(6, 1);
                }
            }
        });
        this.register("^T<M$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                int thisMonth = calendar.get(2);
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
                while (thisMonth == calendar.get(2)) {
                    calendar.add(6, -1);
                }
                calendar.add(6, 1);
            }
        });
        this.register("^T\\+(\\d+)M$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(2, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)M$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(2, Integer.parseInt(value) * -1);
            }
        });
        this.register("^T>y$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                int thisYear = calendar.get(1);
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
                while (thisYear == calendar.get(1)) {
                    calendar.add(6, 1);
                }
            }
        });
        this.register("^T<y$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                int thisYear = calendar.get(1);
                calendar.add(11, calendar.get(11) * -1);
                calendar.add(12, calendar.get(12) * -1);
                calendar.add(13, calendar.get(13) * -1);
                calendar.add(14, calendar.get(14) * -1);
                while (thisYear == calendar.get(1)) {
                    calendar.add(6, -1);
                }
                calendar.add(6, 1);
            }
        });
        this.register("^T\\+(\\d+)y$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(1, Integer.parseInt(value));
            }
        });
        this.register("^T\\-(\\d+)y$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(1, Integer.parseInt(value) * -1);
            }
        });
        this.register("^D\\+(\\d+)d$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(6, Integer.parseInt(value));
            }
        });
        this.register("^D\\-(\\d+)d$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(6, Integer.parseInt(value) * -1);
            }
        });
        this.register("^D\\+(\\d+)y$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(1, Integer.parseInt(value));
            }
        });
        this.register("^D\\-(\\d+)y$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(1, Integer.parseInt(value) * -1);
            }
        });
        this.register("^D\\+(\\d+)w$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(3, Integer.parseInt(value));
            }
        });
        this.register("^D\\-(\\d+)w$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(3, Integer.parseInt(value) * -1);
            }
        });
        this.register("^D\\+(\\d+)M$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(2, Integer.parseInt(value));
            }
        });
        this.register("^D\\-(\\d+)M$", new DateModifier(){

            @Override
            public void modify(Calendar calendar, String value) {
                calendar.add(2, Integer.parseInt(value) * -1);
            }
        });
    }

    @Override
    public Date parse(String str) throws DateParseException {
        Date t = null;
        String tmpStr = str;
        int parsedSoFar = 0;
        boolean firstPass = true;
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("Date string should not be null or blank!");
        }
        while (tmpStr.length() > 0) {
            Date tmpT = this.simpleParse(tmpStr, t);
            if (tmpT != null) {
                t = tmpT;
                parsedSoFar = firstPass ? tmpStr.length() : (parsedSoFar += tmpStr.length() - 1);
                tmpStr = "T" + str.substring(parsedSoFar);
                firstPass = false;
            } else {
                tmpStr = tmpStr.substring(0, tmpStr.length() - 1);
            }
            if (!"T".equals(tmpStr)) continue;
            if (parsedSoFar == str.length()) break;
            throw new DateParseException("Could not parse date string [" + str + "]!");
        }
        if (t == null) {
            throw new DateParseException("Could not parse date string [" + str + "]!");
        }
        return t;
    }

    private boolean isDayStarted(String str) {
        return str.startsWith("D");
    }

    private Date simpleParse(String str, Date t) throws DateParseException {
        for (Pattern predicate : this.registrations.keySet()) {
            Matcher matcher = predicate.matcher(str);
            if (!matcher.matches()) continue;
            Object dateParser = this.registrations.get(predicate);
            if (dateParser instanceof DateParser) {
                return ((DateParser)dateParser).parse(str);
            }
            if (!(dateParser instanceof DateModifier)) continue;
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setFirstDayOfWeek(2);
            if (t == null) {
                if (this.isDayStarted(str)) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyyDDmm");
                    try {
                        calendar.setTime(format.parse(format.format(new Date())));
                    }
                    catch (ParseException e) {
                        calendar.setTime(new Date());
                    }
                } else {
                    calendar.setTime(new Date());
                }
            } else {
                calendar.setTime(t);
            }
            ((DateModifier)dateParser).modify(calendar, matcher.groupCount() > 0 ? matcher.group(1) : null);
            return calendar.getTime();
        }
        return null;
    }

    public void register(String regexp, String format) {
        if (regexp == null || regexp.length() == 0) {
            throw new IllegalArgumentException("Regular expression parameter should not be null or blank!");
        }
        this.registrations.put(Pattern.compile(regexp), new BasicDateParser(format));
    }

    public void register(String regexp, DateModifier dateParser) {
        if (regexp == null || regexp.length() == 0) {
            throw new IllegalArgumentException("Regular expression parameter should not be null or blank!");
        }
        this.registrations.put(Pattern.compile(regexp), dateParser);
    }

    public static interface DateModifier {
        public void modify(Calendar var1, String var2);
    }

    private static class BasicDateParser
    implements DateParser {
        private ThreadLocal<DateFormat> dateFormat = null;

        public BasicDateParser(final String format) {
            if (format == null || format.length() == 0) {
                throw new IllegalArgumentException("Format parameter should not be null or blank!");
            }
            this.dateFormat = new ThreadLocal<DateFormat>(){

                @Override
                protected DateFormat initialValue() {
                    return new SimpleDateFormat(format);
                }
            };
        }

        @Override
        public Date parse(String s) throws DateParseException {
            try {
                return this.dateFormat.get().parse(s);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }
}

