/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.desensitization;

import com.cntaiping.ec.cloud.common.utils.desensitization.CipherUtils;
import com.cntaiping.ec.cloud.common.utils.desensitization.DesensitizedUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;

@JsonDeserialize(using=DesensitizedChineseNameJsonDeserializer.class)
@JsonSerialize(using=DesensitizedChineseNameJsonSerializer.class)
public class DesensitizedChineseName {
    private String real;

    public DesensitizedChineseName(String real) {
        this.real = real;
    }

    public String getReal() {
        return this.real;
    }

    public void setReal(String real) {
        this.real = real;
    }

    public String getEncrypted() {
        return CipherUtils.encrypt(this.real);
    }

    public String getDesensitized() {
        return DesensitizedUtils.chineseName(this.real);
    }

    public String toString() {
        return this.getDesensitized();
    }

    public static class DesensitizedChineseNameJsonDeserializer
    extends JsonDeserializer<DesensitizedChineseName> {
        public DesensitizedChineseName deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new DesensitizedChineseName(CipherUtils.decrypt(p.getValueAsString()));
        }
    }

    public static class DesensitizedChineseNameJsonSerializer
    extends JsonSerializer<DesensitizedChineseName> {
        public void serialize(DesensitizedChineseName value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("desensitized", value.getDesensitized());
            gen.writeStringField("encrypted", value.getEncrypted());
            gen.writeEndObject();
        }
    }
}

