/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.desensitization;

import com.cntaiping.ec.cloud.common.utils.desensitization.CipherUtils;
import com.cntaiping.ec.cloud.common.utils.desensitization.DesensitizedUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;

@JsonDeserialize(using=DesensitizedLicensePlateNumberJsonDeserializer.class)
@JsonSerialize(using=DesensitizedLicensePlateNumberJsonSerializer.class)
public class DesensitizedLicensePlateNumber {
    private String real;

    public DesensitizedLicensePlateNumber(String real) {
        this.real = real;
    }

    public String getReal() {
        return this.real;
    }

    public void setReal(String real) {
        this.real = real;
    }

    public String getEncrypted() {
        return CipherUtils.encrypt(this.real);
    }

    public String getDesensitized() {
        return DesensitizedUtils.licensePlateNumber(this.real);
    }

    public String toString() {
        return this.getDesensitized();
    }

    public static class DesensitizedLicensePlateNumberJsonDeserializer
    extends JsonDeserializer<DesensitizedLicensePlateNumber> {
        public DesensitizedLicensePlateNumber deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new DesensitizedLicensePlateNumber(CipherUtils.decrypt(p.getValueAsString()));
        }
    }

    public static class DesensitizedLicensePlateNumberJsonSerializer
    extends JsonSerializer<DesensitizedLicensePlateNumber> {
        public void serialize(DesensitizedLicensePlateNumber value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("desensitized", value.getDesensitized());
            gen.writeStringField("encrypted", value.getEncrypted());
            gen.writeEndObject();
        }
    }
}

