/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.desensitization;

import com.cntaiping.ec.cloud.common.utils.desensitization.CipherUtils;
import com.cntaiping.ec.cloud.common.utils.desensitization.DesensitizedUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;

@JsonDeserialize(using=DesensitizedNickNameJsonDeserializer.class)
@JsonSerialize(using=DesensitizedNickNameJsonSerializer.class)
public class DesensitizedNickName {
    private String real;

    public DesensitizedNickName(String real) {
        this.real = real;
    }

    public String getReal() {
        return this.real;
    }

    public void setReal(String real) {
        this.real = real;
    }

    public String getEncrypted() {
        return CipherUtils.encrypt(this.real);
    }

    public String getDesensitized() {
        return DesensitizedUtils.nickName(this.real);
    }

    public String toString() {
        return this.getDesensitized();
    }

    public static class DesensitizedNickNameJsonDeserializer
    extends JsonDeserializer<DesensitizedNickName> {
        public DesensitizedNickName deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new DesensitizedNickName(CipherUtils.decrypt(p.getValueAsString()));
        }
    }

    public static class DesensitizedNickNameJsonSerializer
    extends JsonSerializer<DesensitizedNickName> {
        public void serialize(DesensitizedNickName value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("desensitized", value.getDesensitized());
            gen.writeStringField("encrypted", value.getEncrypted());
            gen.writeEndObject();
        }
    }
}

