/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.desensitization;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesensitizedUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DesensitizedUtils.class);

    private DesensitizedUtils() {
    }

    public static String chineseName(String fullName) {
        if (StringUtils.isBlank((CharSequence)fullName)) {
            return "";
        }
        String name = StringUtils.right((String)fullName, (int)1);
        return StringUtils.leftPad((String)name, (int)StringUtils.length((CharSequence)fullName), (String)"*");
    }

    public static String nickName(String nickName) {
        if (StringUtils.isBlank((CharSequence)nickName)) {
            return "";
        }
        String name = StringUtils.right((String)nickName, (int)3);
        return StringUtils.leftPad((String)name, (int)StringUtils.length((CharSequence)nickName), (String)"*");
    }

    public static String idCardNum(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return "";
        }
        String first = StringUtils.left((String)id, (int)1);
        String last = StringUtils.right((String)id, (int)1);
        return first + StringUtils.repeat((String)"*", (int)(StringUtils.length((CharSequence)id) - 2)) + last;
    }

    public static String mobile(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        String result = "";
        try {
            if (num.contains("-")) {
                String first = num.substring(0, num.indexOf("-") + 1);
                String second = num.substring(num.indexOf("-") + 1);
                result = first + StringUtils.repeat((String)"*", (int)(second.length() - 4)) + StringUtils.right((String)second, (int)4);
            } else {
                result = StringUtils.left((String)num, (int)3) + StringUtils.repeat((String)"*", (int)(num.length() - 7)) + StringUtils.right((String)num, (int)4);
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.warn("Failed invoke fixedPhone==>{}", (Object)num, (Object)e);
            return result;
        }
    }

    public static String address(String address, int sensitiveSize) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)address);
        return StringUtils.rightPad((String)StringUtils.left((String)address, (int)(length - sensitiveSize)), (int)length, (String)"*");
    }

    public static String email(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return "";
        }
        int index = StringUtils.indexOf((CharSequence)email, (CharSequence)"@");
        if (index <= 1) {
            return email;
        }
        return StringUtils.rightPad((String)StringUtils.left((String)email, (int)1), (int)index, (String)"*").concat(StringUtils.mid((String)email, (int)index, (int)StringUtils.length((CharSequence)email)));
    }

    public static String licensePlateNumber(String licensePlateNumber) {
        if (StringUtils.isBlank((CharSequence)licensePlateNumber)) {
            return "";
        }
        return StringUtils.left((String)licensePlateNumber, (int)2) + StringUtils.repeat((String)"*", (int)(licensePlateNumber.length() - 4)) + StringUtils.right((String)licensePlateNumber, (int)2);
    }

    public static String password(String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return "";
        }
        String pwd = StringUtils.left((String)password, (int)0);
        return StringUtils.rightPad((String)pwd, (int)StringUtils.length((CharSequence)password), (String)"*");
    }

    public static String bankCard(String cardNum) {
        if (StringUtils.isBlank((CharSequence)cardNum)) {
            return "";
        }
        return StringUtils.left((String)cardNum, (int)6).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)cardNum, (int)4), (int)StringUtils.length((CharSequence)cardNum), (String)"*"), (String)"******"));
    }

    public static String cvv(String cvv) {
        if (StringUtils.isBlank((CharSequence)cvv)) {
            return "";
        }
        String pwd = StringUtils.left((String)cvv, (int)0);
        return StringUtils.rightPad((String)pwd, (int)StringUtils.length((CharSequence)cvv), (String)"*");
    }

    public static String validDate(String validDate) {
        if (StringUtils.isBlank((CharSequence)validDate)) {
            return "";
        }
        String[] parts = validDate.split("/");
        if (parts.length > 1) {
            StringBuilder result = new StringBuilder();
            for (String part : parts) {
                result.append(StringUtils.repeat((String)"*", (int)part.length())).append("/");
            }
            return result.substring(0, result.length() - 1);
        }
        return StringUtils.repeat((String)"*", (int)validDate.length());
    }

    public static String birthday(String birthday) {
        if (StringUtils.isBlank((CharSequence)birthday)) {
            return "";
        }
        String[] parts = birthday.split("-");
        if (parts.length > 1) {
            StringBuilder result = new StringBuilder();
            for (String part : parts) {
                result.append(StringUtils.repeat((String)"*", (int)part.length())).append("-");
            }
            return result.substring(0, result.length() - 1);
        }
        return StringUtils.repeat((String)"*", (int)birthday.length());
    }
}

