/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.http;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class IpAddressUtils {
    private static final ThreadLocal<String> IP_THREAD_LOCAL = new InheritableThreadLocal<String>();
    private static final Logger LOGGER = LoggerFactory.getLogger(IpAddressUtils.class);
    private static Pattern INTERNAL_PROXIES = Pattern.compile("10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|20\\.1\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|198\\.19\\.\\d{1,3}\\.\\d{1,3}|198\\.18\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.1[6-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.2[0-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.3[0-1]{1}\\.\\d{1,3}\\.\\d{1,3}|0:0:0:0:0:0:0:1|::1");
    private static final Pattern IPV6 = Pattern.compile("^\\[((?:[0-9a-zA-F]{1,4})(?::[0-9a-zA-F]{1,4}){7})]$");
    private static final String IP_UNKNOWN = "unKnown";
    private static List<String> HEADERS = Arrays.asList("X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR");

    public static String getIpAddress(HttpServletRequest request) {
        String realRemoteAddr = IpAddressUtils.get();
        if (realRemoteAddr != null) {
            return realRemoteAddr;
        }
        String originalRemoteAddr = null;
        for (String header : HEADERS) {
            originalRemoteAddr = request.getHeader(header);
            if (!StringUtils.hasText((String)originalRemoteAddr) || IP_UNKNOWN.equalsIgnoreCase(originalRemoteAddr)) continue;
            realRemoteAddr = IpAddressUtils.getRealIpv6(IpAddressUtils.resolveRemoteIp(originalRemoteAddr));
            break;
        }
        if (realRemoteAddr == null) {
            originalRemoteAddr = request.getRemoteAddr();
            realRemoteAddr = IpAddressUtils.getRealIpv6(originalRemoteAddr);
        }
        LOGGER.debug("\u8fdc\u7a0bIP\u89e3\u6790\u7ed3\u679c::originalRemoteAddr:[{}] ==> realRemoteAddr:[{}]", (Object)originalRemoteAddr, (Object)realRemoteAddr);
        IpAddressUtils.set(realRemoteAddr);
        return realRemoteAddr;
    }

    public static void setInternalProxies(Pattern internalProxies) {
        INTERNAL_PROXIES = internalProxies;
    }

    public static void setHeaders(List<String> headers) {
        HEADERS = headers;
    }

    private static String getRealIpv6(String ipv6) {
        Matcher matcher = IPV6.matcher(ipv6);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return ipv6;
    }

    private static String resolveRemoteIp(String originalRemoteAddr) {
        String[] remoteIpValue = originalRemoteAddr.split("\\s*,\\s*");
        int length = remoteIpValue.length;
        for (int i = length - 1; i >= 0; --i) {
            if (INTERNAL_PROXIES.matcher(remoteIpValue[i]).matches()) continue;
            return remoteIpValue[i];
        }
        return remoteIpValue[0];
    }

    public static String get() {
        return IP_THREAD_LOCAL.get();
    }

    public static void set(String ip) {
        IP_THREAD_LOCAL.set(ip);
    }

    public static void remove() {
        IP_THREAD_LOCAL.remove();
    }
}

