/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.id;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Function;

public class UUID62 {
    public static String randomUUID62() {
        return UUID62.toUUID62(UUID.randomUUID());
    }

    public static String toUUID62(UUID uuid) {
        return Base62.encode(UUIDConverter.toBigInteger(uuid));
    }

    public static UUID toUUID(String uuid62) {
        return UUIDConverter.toUUID(Base62.decode(uuid62));
    }

    static class Base62 {
        private static final BigInteger BASE62 = BigInteger.valueOf(62L);
        private static final char[] TO_BASE62 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        private static final int[] FROM_BASE62 = new int[256];

        Base62() {
        }

        static String encode(BigInteger number) {
            if (number == null || number.compareTo(BigInteger.ZERO) < 0) {
                throw new IllegalArgumentException("The number cannot be negative");
            }
            StringBuilder builder = new StringBuilder();
            while (number.compareTo(BigInteger.ZERO) > 0) {
                BigInteger[] divideAndRemainder = number.divideAndRemainder(BASE62);
                builder.insert(0, TO_BASE62[divideAndRemainder[1].intValue()]);
                number = divideAndRemainder[0];
            }
            return builder.toString();
        }

        static BigInteger decode(String str) {
            if (str == null || str.isEmpty()) {
                throw new IllegalArgumentException("str cannot be empty");
            }
            BigInteger result = BigInteger.valueOf(0L);
            int length = str.length();
            for (int i = 0; i < length; ++i) {
                int value = FROM_BASE62[str.charAt(length - i - 1)];
                result = result.add(BigInteger.valueOf(value).multiply(BASE62.pow(i)));
            }
            return result;
        }

        static {
            Arrays.fill(FROM_BASE62, -1);
            for (int i = 0; i < TO_BASE62.length; ++i) {
                Base62.FROM_BASE62[Base62.TO_BASE62[i]] = i;
            }
        }
    }

    static class UUIDConverter {
        private static final BigInteger HALF = BigInteger.ONE.shiftLeft(64);
        private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        private static final Function<BigInteger, BigInteger> toUnsigned = value -> value.signum() < 0 ? value.add(HALF) : value;
        private static final Function<BigInteger, BigInteger> toSigned = value -> value.compareTo(MAX_LONG) > 0 ? value.subtract(HALF) : value;

        UUIDConverter() {
        }

        static BigInteger toBigInteger(UUID uuid) {
            BigInteger most = BigInteger.valueOf(uuid.getMostSignificantBits());
            BigInteger least = BigInteger.valueOf(uuid.getLeastSignificantBits());
            return toUnsigned.apply(most).multiply(HALF).add(toUnsigned.apply(least));
        }

        static UUID toUUID(BigInteger value) {
            BigInteger[] divideAndRemainder = value.divideAndRemainder(HALF);
            return new UUID(toSigned.apply(divideAndRemainder[0]).longValueExact(), toSigned.apply(divideAndRemainder[1]).longValueExact());
        }
    }
}

